/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.instrument;

import net.kyori.adventure.text.Component;
import net.minestom.server.ServerFlag;
import net.minestom.server.item.instrument.InstrumentImpl;
import net.minestom.server.item.instrument.Instruments;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Instrument
extends ProtocolObject,
Instruments
permits InstrumentImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<Instrument>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::instrument, true);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<Instrument>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::instrument);

    @NotNull
    public static Instrument create(@NotNull SoundEvent soundEvent, float useDuration, float range, @NotNull Component description) {
        return new InstrumentImpl(soundEvent, useDuration, range, description);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Instrument> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:instrument", InstrumentImpl.REGISTRY_NBT_TYPE, Registry.Resource.INSTRUMENTS, (String namespace, Registry.Properties props) -> new InstrumentImpl(Registry.instrument(namespace, props)));
    }

    @NotNull
    public SoundEvent soundEvent();

    public float useDuration();

    default public int useDurationTicks() {
        return (int)(this.useDuration() * (float)ServerFlag.SERVER_TICKS_PER_SECOND);
    }

    public float range();

    @NotNull
    public Component description();

    @Override
    @Nullable
    public Registry.InstrumentEntry registry();

    public static final class Builder {
        private SoundEvent soundEvent;
        private float useDuration;
        private float range;
        private Component description;

        private Builder() {
        }

        @NotNull
        public Builder soundEvent(@NotNull SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        @NotNull
        public Builder useDuration(float useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        @NotNull
        public Builder range(float range) {
            this.range = range;
            return this;
        }

        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Instrument build() {
            return new InstrumentImpl(this.soundEvent, this.useDuration, this.range, this.description);
        }
    }
}

