/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.PlayerMeta;
import net.minestom.server.entity.metadata.ambient.BatMeta;
import net.minestom.server.entity.metadata.animal.ArmadilloMeta;
import net.minestom.server.entity.metadata.animal.BeeMeta;
import net.minestom.server.entity.metadata.animal.CamelMeta;
import net.minestom.server.entity.metadata.animal.ChickenMeta;
import net.minestom.server.entity.metadata.animal.CowMeta;
import net.minestom.server.entity.metadata.animal.DonkeyMeta;
import net.minestom.server.entity.metadata.animal.FoxMeta;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.GoatMeta;
import net.minestom.server.entity.metadata.animal.HoglinMeta;
import net.minestom.server.entity.metadata.animal.HorseMeta;
import net.minestom.server.entity.metadata.animal.LlamaMeta;
import net.minestom.server.entity.metadata.animal.MooshroomMeta;
import net.minestom.server.entity.metadata.animal.MuleMeta;
import net.minestom.server.entity.metadata.animal.OcelotMeta;
import net.minestom.server.entity.metadata.animal.PandaMeta;
import net.minestom.server.entity.metadata.animal.PigMeta;
import net.minestom.server.entity.metadata.animal.PolarBearMeta;
import net.minestom.server.entity.metadata.animal.RabbitMeta;
import net.minestom.server.entity.metadata.animal.SheepMeta;
import net.minestom.server.entity.metadata.animal.SkeletonHorseMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.StriderMeta;
import net.minestom.server.entity.metadata.animal.TurtleMeta;
import net.minestom.server.entity.metadata.animal.ZombieHorseMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.entity.metadata.animal.tameable.ParrotMeta;
import net.minestom.server.entity.metadata.animal.tameable.WolfMeta;
import net.minestom.server.entity.metadata.display.BlockDisplayMeta;
import net.minestom.server.entity.metadata.display.ItemDisplayMeta;
import net.minestom.server.entity.metadata.display.TextDisplayMeta;
import net.minestom.server.entity.metadata.flying.GhastMeta;
import net.minestom.server.entity.metadata.flying.PhantomMeta;
import net.minestom.server.entity.metadata.golem.IronGolemMeta;
import net.minestom.server.entity.metadata.golem.ShulkerMeta;
import net.minestom.server.entity.metadata.golem.SnowGolemMeta;
import net.minestom.server.entity.metadata.item.EyeOfEnderMeta;
import net.minestom.server.entity.metadata.item.FireballMeta;
import net.minestom.server.entity.metadata.item.ItemEntityMeta;
import net.minestom.server.entity.metadata.item.SmallFireballMeta;
import net.minestom.server.entity.metadata.item.SnowballMeta;
import net.minestom.server.entity.metadata.item.ThrownEggMeta;
import net.minestom.server.entity.metadata.item.ThrownEnderPearlMeta;
import net.minestom.server.entity.metadata.item.ThrownExperienceBottleMeta;
import net.minestom.server.entity.metadata.item.ThrownPotionMeta;
import net.minestom.server.entity.metadata.minecart.ChestMinecartMeta;
import net.minestom.server.entity.metadata.minecart.CommandBlockMinecartMeta;
import net.minestom.server.entity.metadata.minecart.FurnaceMinecartMeta;
import net.minestom.server.entity.metadata.minecart.HopperMinecartMeta;
import net.minestom.server.entity.metadata.minecart.MinecartMeta;
import net.minestom.server.entity.metadata.minecart.SpawnerMinecartMeta;
import net.minestom.server.entity.metadata.minecart.TntMinecartMeta;
import net.minestom.server.entity.metadata.monster.BlazeMeta;
import net.minestom.server.entity.metadata.monster.BreezeMeta;
import net.minestom.server.entity.metadata.monster.CaveSpiderMeta;
import net.minestom.server.entity.metadata.monster.CreakingMeta;
import net.minestom.server.entity.metadata.monster.CreeperMeta;
import net.minestom.server.entity.metadata.monster.ElderGuardianMeta;
import net.minestom.server.entity.metadata.monster.EndermanMeta;
import net.minestom.server.entity.metadata.monster.EndermiteMeta;
import net.minestom.server.entity.metadata.monster.GiantMeta;
import net.minestom.server.entity.metadata.monster.GuardianMeta;
import net.minestom.server.entity.metadata.monster.PiglinBruteMeta;
import net.minestom.server.entity.metadata.monster.PiglinMeta;
import net.minestom.server.entity.metadata.monster.SilverfishMeta;
import net.minestom.server.entity.metadata.monster.SpiderMeta;
import net.minestom.server.entity.metadata.monster.VexMeta;
import net.minestom.server.entity.metadata.monster.WardenMeta;
import net.minestom.server.entity.metadata.monster.WitherMeta;
import net.minestom.server.entity.metadata.monster.ZoglinMeta;
import net.minestom.server.entity.metadata.monster.raider.EvokerMeta;
import net.minestom.server.entity.metadata.monster.raider.IllusionerMeta;
import net.minestom.server.entity.metadata.monster.raider.PillagerMeta;
import net.minestom.server.entity.metadata.monster.raider.RavagerMeta;
import net.minestom.server.entity.metadata.monster.raider.VindicatorMeta;
import net.minestom.server.entity.metadata.monster.raider.WitchMeta;
import net.minestom.server.entity.metadata.monster.skeleton.BoggedMeta;
import net.minestom.server.entity.metadata.monster.skeleton.SkeletonMeta;
import net.minestom.server.entity.metadata.monster.skeleton.StrayMeta;
import net.minestom.server.entity.metadata.monster.skeleton.WitherSkeletonMeta;
import net.minestom.server.entity.metadata.monster.zombie.DrownedMeta;
import net.minestom.server.entity.metadata.monster.zombie.HuskMeta;
import net.minestom.server.entity.metadata.monster.zombie.ZombieMeta;
import net.minestom.server.entity.metadata.monster.zombie.ZombieVillagerMeta;
import net.minestom.server.entity.metadata.monster.zombie.ZombifiedPiglinMeta;
import net.minestom.server.entity.metadata.other.AllayMeta;
import net.minestom.server.entity.metadata.other.AreaEffectCloudMeta;
import net.minestom.server.entity.metadata.other.ArmorStandMeta;
import net.minestom.server.entity.metadata.other.BoatMeta;
import net.minestom.server.entity.metadata.other.EndCrystalMeta;
import net.minestom.server.entity.metadata.other.EnderDragonMeta;
import net.minestom.server.entity.metadata.other.EvokerFangsMeta;
import net.minestom.server.entity.metadata.other.ExperienceOrbMeta;
import net.minestom.server.entity.metadata.other.FallingBlockMeta;
import net.minestom.server.entity.metadata.other.FishingHookMeta;
import net.minestom.server.entity.metadata.other.GlowItemFrameMeta;
import net.minestom.server.entity.metadata.other.InteractionMeta;
import net.minestom.server.entity.metadata.other.ItemFrameMeta;
import net.minestom.server.entity.metadata.other.LeashKnotMeta;
import net.minestom.server.entity.metadata.other.LightningBoltMeta;
import net.minestom.server.entity.metadata.other.LlamaSpitMeta;
import net.minestom.server.entity.metadata.other.MagmaCubeMeta;
import net.minestom.server.entity.metadata.other.MarkerMeta;
import net.minestom.server.entity.metadata.other.OminousItemSpawnerMeta;
import net.minestom.server.entity.metadata.other.PaintingMeta;
import net.minestom.server.entity.metadata.other.PrimedTntMeta;
import net.minestom.server.entity.metadata.other.ShulkerBulletMeta;
import net.minestom.server.entity.metadata.other.SlimeMeta;
import net.minestom.server.entity.metadata.other.TraderLlamaMeta;
import net.minestom.server.entity.metadata.projectile.ArrowMeta;
import net.minestom.server.entity.metadata.projectile.BreezeWindChargeMeta;
import net.minestom.server.entity.metadata.projectile.DragonFireballMeta;
import net.minestom.server.entity.metadata.projectile.FireworkRocketMeta;
import net.minestom.server.entity.metadata.projectile.SpectralArrowMeta;
import net.minestom.server.entity.metadata.projectile.ThrownTridentMeta;
import net.minestom.server.entity.metadata.projectile.WindChargeMeta;
import net.minestom.server.entity.metadata.projectile.WitherSkullMeta;
import net.minestom.server.entity.metadata.villager.VillagerMeta;
import net.minestom.server.entity.metadata.villager.WanderingTraderMeta;
import net.minestom.server.entity.metadata.water.AxolotlMeta;
import net.minestom.server.entity.metadata.water.DolphinMeta;
import net.minestom.server.entity.metadata.water.GlowSquidMeta;
import net.minestom.server.entity.metadata.water.SquidMeta;
import net.minestom.server.entity.metadata.water.fish.CodMeta;
import net.minestom.server.entity.metadata.water.fish.PufferfishMeta;
import net.minestom.server.entity.metadata.water.fish.SalmonMeta;
import net.minestom.server.entity.metadata.water.fish.TadpoleMeta;
import net.minestom.server.entity.metadata.water.fish.TropicalFishMeta;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetadataHolder {
    private static final VarHandle NOTIFIED_CHANGES;
    private final Entity entity;
    private final Int2ObjectMap<Metadata.Entry<?>> entries = new Int2ObjectOpenHashMap();
    private volatile boolean notifyAboutChanges = true;
    private final Map<Integer, Metadata.Entry<?>> notNotifiedChanges = new HashMap();
    static final Map<String, BiFunction<Entity, MetadataHolder, EntityMeta>> ENTITY_META_SUPPLIER;

    public MetadataHolder(@Nullable Entity entity) {
        this.entity = entity;
    }

    public <T> T get( @NotNull MetadataDef.Entry<T> entry) {
        int id = entry.index();
        Metadata.Entry value = (Metadata.Entry)this.entries.get(id);
        if (value == null) {
            return entry.defaultValue();
        }
        MetadataDef.Entry<T> entry2 = entry;
        Objects.requireNonNull(entry2);
        MetadataDef.Entry<T> entry3 = entry2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetadataDef.Entry.Index.class, MetadataDef.Entry.BitMask.class, MetadataDef.Entry.ByteMask.class}, entry3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                MetadataDef.Entry.Index v = (MetadataDef.Entry.Index)entry3;
                yield value.value();
            }
            case 1 -> {
                MetadataDef.Entry.BitMask bitMask = (MetadataDef.Entry.BitMask)entry3;
                byte maskValue = (Byte)value.value();
                yield this.getMaskBit(maskValue, bitMask.bitMask());
            }
            case 2 -> {
                MetadataDef.Entry.ByteMask byteMask = (MetadataDef.Entry.ByteMask)entry3;
                byte maskValue = (Byte)value.value();
                yield this.getMaskByte(maskValue, byteMask.byteMask(), byteMask.offset());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set( @NotNull MetadataDef.Entry<T> entry, T value) {
        int id = entry.index();
        MetadataDef.Entry<T> entry2 = entry;
        Objects.requireNonNull(entry2);
        MetadataDef.Entry<T> entry3 = entry2;
        int n = 0;
        Metadata.Entry result = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MetadataDef.Entry.Index.class, MetadataDef.Entry.BitMask.class, MetadataDef.Entry.ByteMask.class}, entry3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                MetadataDef.Entry.Index v = (MetadataDef.Entry.Index)entry3;
                yield v.function().apply(value);
            }
            case 1 -> {
                MetadataDef.Entry.BitMask bitMask = (MetadataDef.Entry.BitMask)entry3;
                Metadata.Entry currentEntry = (Metadata.Entry)this.entries.get(id);
                byte maskValue = currentEntry != null ? (Byte)currentEntry.value() : (byte)0;
                maskValue = this.setMaskBit(maskValue, bitMask.bitMask(), (Boolean)value);
                yield Metadata.Byte(maskValue);
            }
            case 2 -> {
                MetadataDef.Entry.ByteMask byteMask = (MetadataDef.Entry.ByteMask)entry3;
                Metadata.Entry currentEntry = (Metadata.Entry)this.entries.get(id);
                byte maskValue = currentEntry != null ? (Byte)currentEntry.value() : (byte)0;
                maskValue = this.setMaskByte(maskValue, byteMask.byteMask(), byteMask.offset(), (Byte)value);
                yield Metadata.Byte(maskValue);
            }
        };
        this.entries.put(id, result);
        Entity entity = this.entity;
        if (entity != null && entity.isActive()) {
            if (!this.notifyAboutChanges) {
                Map<Integer, Metadata.Entry<?>> map = this.notNotifiedChanges;
                synchronized (map) {
                    this.notNotifiedChanges.put(id, result);
                }
            } else {
                entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), Map.of(id, result)));
            }
        }
    }

    private boolean getMaskBit(byte maskValue, byte bit) {
        return (maskValue & bit) == bit;
    }

    private byte setMaskBit(byte mask, byte bit, boolean value) {
        return value ? (byte)(mask | bit) : (byte)(mask & ~bit);
    }

    private byte getMaskByte(byte data, byte byteMask, int offset) {
        return (byte)((data & byteMask) >> offset);
    }

    private byte setMaskByte(byte data, byte byteMask, int offset, byte newValue) {
        return (byte)(data & ~byteMask | newValue << offset & byteMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        Map<Integer, Metadata.Entry<?>> entries;
        if (!NOTIFIED_CHANGES.compareAndSet(this, !notifyAboutChanges, notifyAboutChanges)) {
            return;
        }
        if (!notifyAboutChanges) {
            return;
        }
        Entity entity = this.entity;
        if (entity == null || !entity.isActive()) {
            return;
        }
        Map<Integer, Metadata.Entry<?>> map = this.notNotifiedChanges;
        synchronized (map) {
            Map<Integer, Metadata.Entry<?>> awaitingChanges = this.notNotifiedChanges;
            if (awaitingChanges.isEmpty()) {
                return;
            }
            entries = Map.copyOf(awaitingChanges);
            awaitingChanges.clear();
        }
        entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), entries));
    }

    @NotNull
    public Map<Integer, Metadata.Entry<?>> getEntries() {
        return Map.copyOf(this.entries);
    }

    @ApiStatus.Internal
    public static EntityMeta createMeta(@NotNull EntityType entityType, @Nullable Entity entity, @NotNull MetadataHolder metadata) {
        return ENTITY_META_SUPPLIER.get(entityType.name()).apply(entity, metadata);
    }

    private static Map<String, BiFunction<Entity, MetadataHolder, EntityMeta>> createMetaMap() {
        return Map.ofEntries(Map.entry("minecraft:acacia_boat", BoatMeta::new), Map.entry("minecraft:acacia_chest_boat", BoatMeta::new), Map.entry("minecraft:allay", AllayMeta::new), Map.entry("minecraft:area_effect_cloud", AreaEffectCloudMeta::new), Map.entry("minecraft:armadillo", ArmadilloMeta::new), Map.entry("minecraft:armor_stand", ArmorStandMeta::new), Map.entry("minecraft:arrow", ArrowMeta::new), Map.entry("minecraft:axolotl", AxolotlMeta::new), Map.entry("minecraft:bamboo_raft", BoatMeta::new), Map.entry("minecraft:bamboo_chest_raft", BoatMeta::new), Map.entry("minecraft:bat", BatMeta::new), Map.entry("minecraft:bee", BeeMeta::new), Map.entry("minecraft:birch_boat", BoatMeta::new), Map.entry("minecraft:birch_chest_boat", BoatMeta::new), Map.entry("minecraft:blaze", BlazeMeta::new), Map.entry("minecraft:block_display", BlockDisplayMeta::new), Map.entry("minecraft:bogged", BoggedMeta::new), Map.entry("minecraft:breeze", BreezeMeta::new), Map.entry("minecraft:breeze_wind_charge", BreezeWindChargeMeta::new), Map.entry("minecraft:camel", CamelMeta::new), Map.entry("minecraft:cat", CatMeta::new), Map.entry("minecraft:cave_spider", CaveSpiderMeta::new), Map.entry("minecraft:cherry_boat", BoatMeta::new), Map.entry("minecraft:cherry_chest_boat", BoatMeta::new), Map.entry("minecraft:chicken", ChickenMeta::new), Map.entry("minecraft:cod", CodMeta::new), Map.entry("minecraft:cow", CowMeta::new), Map.entry("minecraft:creaking", CreakingMeta::new), Map.entry("minecraft:creeper", CreeperMeta::new), Map.entry("minecraft:dark_oak_boat", BoatMeta::new), Map.entry("minecraft:dark_oak_chest_boat", BoatMeta::new), Map.entry("minecraft:dolphin", DolphinMeta::new), Map.entry("minecraft:donkey", DonkeyMeta::new), Map.entry("minecraft:dragon_fireball", DragonFireballMeta::new), Map.entry("minecraft:drowned", DrownedMeta::new), Map.entry("minecraft:elder_guardian", ElderGuardianMeta::new), Map.entry("minecraft:end_crystal", EndCrystalMeta::new), Map.entry("minecraft:ender_dragon", EnderDragonMeta::new), Map.entry("minecraft:enderman", EndermanMeta::new), Map.entry("minecraft:endermite", EndermiteMeta::new), Map.entry("minecraft:evoker", EvokerMeta::new), Map.entry("minecraft:evoker_fangs", EvokerFangsMeta::new), Map.entry("minecraft:experience_orb", ExperienceOrbMeta::new), Map.entry("minecraft:eye_of_ender", EyeOfEnderMeta::new), Map.entry("minecraft:falling_block", FallingBlockMeta::new), Map.entry("minecraft:firework_rocket", FireworkRocketMeta::new), Map.entry("minecraft:fox", FoxMeta::new), Map.entry("minecraft:frog", FrogMeta::new), Map.entry("minecraft:ghast", GhastMeta::new), Map.entry("minecraft:giant", GiantMeta::new), Map.entry("minecraft:glow_item_frame", GlowItemFrameMeta::new), Map.entry("minecraft:glow_squid", GlowSquidMeta::new), Map.entry("minecraft:goat", GoatMeta::new), Map.entry("minecraft:guardian", GuardianMeta::new), Map.entry("minecraft:hoglin", HoglinMeta::new), Map.entry("minecraft:horse", HorseMeta::new), Map.entry("minecraft:husk", HuskMeta::new), Map.entry("minecraft:illusioner", IllusionerMeta::new), Map.entry("minecraft:interaction", InteractionMeta::new), Map.entry("minecraft:iron_golem", IronGolemMeta::new), Map.entry("minecraft:item", ItemEntityMeta::new), Map.entry("minecraft:item_display", ItemDisplayMeta::new), Map.entry("minecraft:item_frame", ItemFrameMeta::new), Map.entry("minecraft:jungle_boat", BoatMeta::new), Map.entry("minecraft:jungle_chest_boat", BoatMeta::new), Map.entry("minecraft:fireball", FireballMeta::new), Map.entry("minecraft:leash_knot", LeashKnotMeta::new), Map.entry("minecraft:lightning_bolt", LightningBoltMeta::new), Map.entry("minecraft:llama", LlamaMeta::new), Map.entry("minecraft:llama_spit", LlamaSpitMeta::new), Map.entry("minecraft:magma_cube", MagmaCubeMeta::new), Map.entry("minecraft:mangrove_boat", BoatMeta::new), Map.entry("minecraft:mangrove_chest_boat", BoatMeta::new), Map.entry("minecraft:marker", MarkerMeta::new), Map.entry("minecraft:minecart", MinecartMeta::new), Map.entry("minecraft:chest_minecart", ChestMinecartMeta::new), Map.entry("minecraft:command_block_minecart", CommandBlockMinecartMeta::new), Map.entry("minecraft:furnace_minecart", FurnaceMinecartMeta::new), Map.entry("minecraft:hopper_minecart", HopperMinecartMeta::new), Map.entry("minecraft:spawner_minecart", SpawnerMinecartMeta::new), Map.entry("minecraft:text_display", TextDisplayMeta::new), Map.entry("minecraft:tnt_minecart", TntMinecartMeta::new), Map.entry("minecraft:mooshroom", MooshroomMeta::new), Map.entry("minecraft:mule", MuleMeta::new), Map.entry("minecraft:oak_boat", BoatMeta::new), Map.entry("minecraft:oak_chest_boat", BoatMeta::new), Map.entry("minecraft:ocelot", OcelotMeta::new), Map.entry("minecraft:ominous_item_spawner", OminousItemSpawnerMeta::new), Map.entry("minecraft:painting", PaintingMeta::new), Map.entry("minecraft:pale_oak_boat", BoatMeta::new), Map.entry("minecraft:pale_oak_chest_boat", BoatMeta::new), Map.entry("minecraft:panda", PandaMeta::new), Map.entry("minecraft:parrot", ParrotMeta::new), Map.entry("minecraft:phantom", PhantomMeta::new), Map.entry("minecraft:pig", PigMeta::new), Map.entry("minecraft:piglin", PiglinMeta::new), Map.entry("minecraft:piglin_brute", PiglinBruteMeta::new), Map.entry("minecraft:pillager", PillagerMeta::new), Map.entry("minecraft:polar_bear", PolarBearMeta::new), Map.entry("minecraft:tnt", PrimedTntMeta::new), Map.entry("minecraft:pufferfish", PufferfishMeta::new), Map.entry("minecraft:rabbit", RabbitMeta::new), Map.entry("minecraft:ravager", RavagerMeta::new), Map.entry("minecraft:salmon", SalmonMeta::new), Map.entry("minecraft:sheep", SheepMeta::new), Map.entry("minecraft:shulker", ShulkerMeta::new), Map.entry("minecraft:shulker_bullet", ShulkerBulletMeta::new), Map.entry("minecraft:silverfish", SilverfishMeta::new), Map.entry("minecraft:skeleton", SkeletonMeta::new), Map.entry("minecraft:skeleton_horse", SkeletonHorseMeta::new), Map.entry("minecraft:slime", SlimeMeta::new), Map.entry("minecraft:small_fireball", SmallFireballMeta::new), Map.entry("minecraft:sniffer", SnifferMeta::new), Map.entry("minecraft:snow_golem", SnowGolemMeta::new), Map.entry("minecraft:snowball", SnowballMeta::new), Map.entry("minecraft:spectral_arrow", SpectralArrowMeta::new), Map.entry("minecraft:spider", SpiderMeta::new), Map.entry("minecraft:spruce_boat", BoatMeta::new), Map.entry("minecraft:spruce_chest_boat", BoatMeta::new), Map.entry("minecraft:squid", SquidMeta::new), Map.entry("minecraft:stray", StrayMeta::new), Map.entry("minecraft:strider", StriderMeta::new), Map.entry("minecraft:tadpole", TadpoleMeta::new), Map.entry("minecraft:egg", ThrownEggMeta::new), Map.entry("minecraft:ender_pearl", ThrownEnderPearlMeta::new), Map.entry("minecraft:experience_bottle", ThrownExperienceBottleMeta::new), Map.entry("minecraft:potion", ThrownPotionMeta::new), Map.entry("minecraft:trident", ThrownTridentMeta::new), Map.entry("minecraft:trader_llama", TraderLlamaMeta::new), Map.entry("minecraft:tropical_fish", TropicalFishMeta::new), Map.entry("minecraft:turtle", TurtleMeta::new), Map.entry("minecraft:vex", VexMeta::new), Map.entry("minecraft:villager", VillagerMeta::new), Map.entry("minecraft:vindicator", VindicatorMeta::new), Map.entry("minecraft:wandering_trader", WanderingTraderMeta::new), Map.entry("minecraft:warden", WardenMeta::new), Map.entry("minecraft:wind_charge", WindChargeMeta::new), Map.entry("minecraft:witch", WitchMeta::new), Map.entry("minecraft:wither", WitherMeta::new), Map.entry("minecraft:wither_skeleton", WitherSkeletonMeta::new), Map.entry("minecraft:wither_skull", WitherSkullMeta::new), Map.entry("minecraft:wolf", WolfMeta::new), Map.entry("minecraft:zoglin", ZoglinMeta::new), Map.entry("minecraft:zombie", ZombieMeta::new), Map.entry("minecraft:zombie_horse", ZombieHorseMeta::new), Map.entry("minecraft:zombie_villager", ZombieVillagerMeta::new), Map.entry("minecraft:zombified_piglin", ZombifiedPiglinMeta::new), Map.entry("minecraft:player", PlayerMeta::new), Map.entry("minecraft:fishing_bobber", FishingHookMeta::new));
    }

    static {
        try {
            NOTIFIED_CHANGES = MethodHandles.lookup().findVarHandle(MetadataHolder.class, "notifyAboutChanges", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        ENTITY_META_SUPPLIER = MetadataHolder.createMetaMap();
    }
}

