/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.nbt;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.item.ItemStack;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.UUIDUtils;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
public interface BinaryTagSerializer<T> {
    public static final BinaryTagSerializer<Unit> UNIT = new BinaryTagSerializer<Unit>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Unit value) {
            return CompoundBinaryTag.empty();
        }

        @Override
        @NotNull
        public Unit read(@NotNull BinaryTag tag) {
            return Unit.INSTANCE;
        }
    };
    public static final BinaryTagSerializer<Byte> BYTE = new BinaryTagSerializer<Byte>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Byte value) {
            return ByteBinaryTag.byteBinaryTag((byte)value);
        }

        @Override
        @NotNull
        public Byte read(@NotNull BinaryTag tag) {
            Byte by;
            if (tag instanceof ByteBinaryTag) {
                ByteBinaryTag byteBinaryTag = (ByteBinaryTag)tag;
                by = byteBinaryTag.value();
            } else {
                by = 0;
            }
            return by;
        }
    };
    public static final BinaryTagSerializer<Boolean> BOOLEAN = BYTE.map(b -> b != 0, b -> (byte)(b != false ? 1 : 0));
    public static final BinaryTagSerializer<Integer> INT = new BinaryTagSerializer<Integer>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Integer value) {
            return IntBinaryTag.intBinaryTag((int)value);
        }

        @Override
        @NotNull
        public Integer read(@NotNull BinaryTag tag) {
            Integer n;
            if (tag instanceof NumberBinaryTag) {
                NumberBinaryTag numberTag = (NumberBinaryTag)tag;
                n = numberTag.intValue();
            } else {
                n = 0;
            }
            return n;
        }
    };
    public static final BinaryTagSerializer<Float> FLOAT = new BinaryTagSerializer<Float>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Float value) {
            return FloatBinaryTag.floatBinaryTag((float)value.floatValue());
        }

        @Override
        @NotNull
        public Float read(@NotNull BinaryTag tag) {
            Float f;
            if (tag instanceof NumberBinaryTag) {
                NumberBinaryTag numberTag = (NumberBinaryTag)tag;
                f = Float.valueOf(numberTag.floatValue());
            } else {
                f = Float.valueOf(0.0f);
            }
            return f;
        }
    };
    public static final BinaryTagSerializer<Double> DOUBLE = new BinaryTagSerializer<Double>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Double value) {
            return DoubleBinaryTag.doubleBinaryTag((double)value);
        }

        @Override
        @NotNull
        public Double read(@NotNull BinaryTag tag) {
            Double d;
            if (tag instanceof NumberBinaryTag) {
                NumberBinaryTag numberTag = (NumberBinaryTag)tag;
                d = numberTag.doubleValue();
            } else {
                d = 0.0;
            }
            return d;
        }
    };
    public static final BinaryTagSerializer<String> STRING = new BinaryTagSerializer<String>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull String value) {
            return StringBinaryTag.stringBinaryTag((String)value);
        }

        @Override
        @NotNull
        public String read(@NotNull BinaryTag tag) {
            String string;
            if (tag instanceof StringBinaryTag) {
                StringBinaryTag stringBinaryTag = (StringBinaryTag)tag;
                string = stringBinaryTag.value();
            } else {
                string = "";
            }
            return string;
        }
    };
    public static final BinaryTagSerializer<CompoundBinaryTag> COMPOUND = new BinaryTagSerializer<CompoundBinaryTag>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull CompoundBinaryTag value) {
            return value;
        }

        @Override
        @NotNull
        public CompoundBinaryTag read(@NotNull BinaryTag tag) {
            CompoundBinaryTag compoundBinaryTag;
            return tag instanceof CompoundBinaryTag ? (compoundBinaryTag = (CompoundBinaryTag)tag) : CompoundBinaryTag.empty();
        }
    };
    public static final BinaryTagSerializer<CompoundBinaryTag> COMPOUND_COERCED = BinaryTagSerializer.coerced(BinaryTagTypes.COMPOUND);
    public static final BinaryTagSerializer<Component> JSON_COMPONENT = STRING.map(s -> GsonComponentSerializer.gson().deserialize(s), c -> (String)GsonComponentSerializer.gson().serialize(c));
    public static final BinaryTagSerializer<Component> NBT_COMPONENT = new BinaryTagSerializer<Component>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Component value) {
            return (BinaryTag)NbtComponentSerializer.nbt().serialize(value);
        }

        @Override
        @NotNull
        public Component read(@NotNull BinaryTag tag) {
            return NbtComponentSerializer.nbt().deserialize(tag);
        }
    };
    public static final BinaryTagSerializer<Style> NBT_COMPONENT_STYLE = new BinaryTagSerializer<Style>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Style value) {
            return NbtComponentSerializer.nbt().serializeStyle(value);
        }

        @Override
        @NotNull
        public Style read(@NotNull BinaryTag tag) {
            return NbtComponentSerializer.nbt().deserializeStyle(tag);
        }
    };
    public static final BinaryTagSerializer<ItemStack> ITEM = COMPOUND.map(ItemStack::fromItemNBT, ItemStack::toItemNBT);
    public static final BinaryTagSerializer<UUID> UUID = new BinaryTagSerializer<UUID>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull UUID value) {
            return UUIDUtils.toNbt(value);
        }

        @Override
        public @NotNull UUID read(@NotNull BinaryTag tag) {
            if (!(tag instanceof IntArrayBinaryTag)) {
                throw new IllegalArgumentException("unexpected uuid type: " + String.valueOf(tag.type()));
            }
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return UUIDUtils.fromNbt(intArrayTag);
        }
    };
    public static final BinaryTagSerializer<Point> BLOCK_POSITION = new BinaryTagSerializer<Point>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Point value) {
            return IntArrayBinaryTag.intArrayBinaryTag((int[])new int[]{value.blockX(), value.blockY(), value.blockZ()});
        }

        @Override
        @NotNull
        public Point read(@NotNull BinaryTag tag) {
            if (!(tag instanceof IntArrayBinaryTag)) {
                return Vec.ZERO;
            }
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            int[] value = intArrayTag.value();
            return new Vec(value[0], value[1], value[2]);
        }
    };
    public static final BinaryTagSerializer<Point> VECTOR3D = new BinaryTagSerializer<Point>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Point value) {
            return ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.DOUBLE, List.of(DoubleBinaryTag.doubleBinaryTag((double)value.x()), DoubleBinaryTag.doubleBinaryTag((double)value.y()), DoubleBinaryTag.doubleBinaryTag((double)value.z())));
        }

        @Override
        @NotNull
        public Point read(@NotNull BinaryTag tag) {
            ListBinaryTag listTag;
            if (!(tag instanceof ListBinaryTag) || (listTag = (ListBinaryTag)tag).elementType() != BinaryTagTypes.DOUBLE) {
                return Vec.ZERO;
            }
            return new Vec(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
        }
    };

    @NotNull
    public static <T> BinaryTagSerializer<T> recursive(final @NotNull Function<BinaryTagSerializer<T>, BinaryTagSerializer<T>> self) {
        return new BinaryTagSerializer<T>(){
            private BinaryTagSerializer<T> serializer = null;

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull T value) {
                return this.serializer().write(context, value);
            }

            @Override
            @NotNull
            public T read(@NotNull Context context, @NotNull BinaryTag tag) {
                return this.serializer().read(context, tag);
            }

            private BinaryTagSerializer<T> serializer() {
                if (this.serializer == null) {
                    this.serializer = (BinaryTagSerializer)self.apply(this);
                }
                return this.serializer;
            }
        };
    }

    @NotNull
    public static <T> BinaryTagSerializer<T> lazy(final @NotNull Supplier<BinaryTagSerializer<T>> self) {
        return new BinaryTagSerializer<T>(){
            private BinaryTagSerializer<T> serializer = null;

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull T value) {
                return this.serializer().write(context, value);
            }

            @Override
            @NotNull
            public T read(@NotNull Context context, @NotNull BinaryTag tag) {
                return this.serializer().read(context, tag);
            }

            private BinaryTagSerializer<T> serializer() {
                if (this.serializer == null) {
                    this.serializer = (BinaryTagSerializer)self.get();
                }
                return this.serializer;
            }
        };
    }

    @NotNull
    public static <T extends BinaryTag> BinaryTagSerializer<T> coerced(final @NotNull BinaryTagType<T> type) {
        return new BinaryTagSerializer<T>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull T value) {
                return value;
            }

            @Override
            @NotNull
            public T read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (tag.type() == type) {
                    return tag;
                }
                if (tag instanceof StringBinaryTag) {
                    StringBinaryTag string = (StringBinaryTag)tag;
                    try {
                        tag = TagStringIOExt.readTag(string.value());
                        if (tag.type() == type) {
                            return tag;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Expected " + String.valueOf(type) + " but got " + String.valueOf(tag));
            }
        };
    }

    @NotNull
    public static <E extends Enum<E>> BinaryTagSerializer<E> fromEnumKeyed(@NotNull Class<E> enumClass) {
        final Enum[] values = (Enum[])enumClass.getEnumConstants();
        final Map nameMap = Arrays.stream(values).collect(Collectors.toMap(rec$ -> ((Keyed)rec$).key(), Function.identity()));
        return new BinaryTagSerializer<E>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull E value) {
                return StringBinaryTag.stringBinaryTag((String)((Keyed)value).key().asString());
            }

            @Override
            @NotNull
            public E read(@NotNull BinaryTag tag) {
                if (!(tag instanceof StringBinaryTag)) {
                    throw new IllegalArgumentException("Expected string, got " + String.valueOf(tag.type()));
                }
                StringBinaryTag string = (StringBinaryTag)tag;
                return nameMap.getOrDefault(Key.key((String)string.value()), values[0]);
            }
        };
    }

    @NotNull
    public static <E extends Enum<E>> BinaryTagSerializer<E> fromEnumStringable(@NotNull Class<E> enumClass) {
        final Enum[] values = (Enum[])enumClass.getEnumConstants();
        final Map nameMap = Arrays.stream(values).collect(Collectors.toMap(e -> e.name().toLowerCase(Locale.ROOT), Function.identity()));
        return new BinaryTagSerializer<E>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull E value) {
                return StringBinaryTag.stringBinaryTag((String)((Enum)value).name().toLowerCase(Locale.ROOT));
            }

            @Override
            @NotNull
            public E read(@NotNull BinaryTag tag) {
                BinaryTag binaryTag = tag;
                Objects.requireNonNull(binaryTag);
                BinaryTag binaryTag2 = binaryTag;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntBinaryTag.class, StringBinaryTag.class}, (Object)binaryTag2, n)) {
                    case 0 -> {
                        IntBinaryTag intBinaryTag = (IntBinaryTag)binaryTag2;
                        yield values[intBinaryTag.value()];
                    }
                    case 1 -> {
                        StringBinaryTag string = (StringBinaryTag)binaryTag2;
                        yield nameMap.getOrDefault(string.value().toLowerCase(Locale.ROOT), values[0]);
                    }
                    default -> values[0];
                };
            }
        };
    }

    @NotNull
    public static <T extends ProtocolObject> BinaryTagSerializer<DynamicRegistry.Key<T>> registryKey(final @NotNull Function<Registries, DynamicRegistry<T>> registrySelector) {
        return new BinaryTagSerializer<DynamicRegistry.Key<T>>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull DynamicRegistry.Key<T> value) {
                return StringBinaryTag.stringBinaryTag((String)value.name());
            }

            @Override
            @NotNull
            public DynamicRegistry.Key<T> read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof StringBinaryTag)) {
                    throw new IllegalArgumentException("Expected string tag for registry key");
                }
                StringBinaryTag s = (StringBinaryTag)tag;
                Registries registries = Objects.requireNonNull(context.registries(), "No registries in context");
                DynamicRegistry registry = (DynamicRegistry)registrySelector.apply(registries);
                DynamicRegistry.Key key = DynamicRegistry.Key.of(s.value());
                Check.argCondition(registry.get(key) == null, "Key is not registered: {0} > {1}", registry, s);
                return key;
            }
        };
    }

    @NotNull
    public static <P1, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull Function<P1, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    BinaryTag child = serializer1.write(context, p1);
                    if (child == null) {
                        return null;
                    }
                    builder.put(param1, child);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)));
            }
        };
    }

    @NotNull
    public static <P1, P2, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull BiFunction<P1, P2, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)));
            }
        };
    }

    @NotNull
    public static <P1, P2, P3, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull String param3, final @NotNull BinaryTagSerializer<P3> serializer3, final @NotNull Function<R, P3> getter3, final @NotNull Function3<P1, P2, P3, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p3;
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                if ((p3 = getter3.apply(value)) != null) {
                    builder.put(param3, serializer3.write(context, p3));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)), serializer3.read(context, compound.get(param3)));
            }
        };
    }

    @NotNull
    public static <P1, P2, P3, P4, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull String param3, final @NotNull BinaryTagSerializer<P3> serializer3, final @NotNull Function<R, P3> getter3, final @NotNull String param4, final @NotNull BinaryTagSerializer<P4> serializer4, final @NotNull Function<R, P4> getter4, final @NotNull Function4<P1, P2, P3, P4, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p4;
                Object p3;
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                if ((p3 = getter3.apply(value)) != null) {
                    builder.put(param3, serializer3.write(context, p3));
                }
                if ((p4 = getter4.apply(value)) != null) {
                    builder.put(param4, serializer4.write(context, p4));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null, null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)), serializer3.read(context, compound.get(param3)), serializer4.read(context, compound.get(param4)));
            }
        };
    }

    @NotNull
    public static <P1, P2, P3, P4, P5, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull String param3, final @NotNull BinaryTagSerializer<P3> serializer3, final @NotNull Function<R, P3> getter3, final @NotNull String param4, final @NotNull BinaryTagSerializer<P4> serializer4, final @NotNull Function<R, P4> getter4, final @NotNull String param5, final @NotNull BinaryTagSerializer<P5> serializer5, final @NotNull Function<R, P5> getter5, final @NotNull Function5<P1, P2, P3, P4, P5, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p5;
                Object p4;
                Object p3;
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                if ((p3 = getter3.apply(value)) != null) {
                    builder.put(param3, serializer3.write(context, p3));
                }
                if ((p4 = getter4.apply(value)) != null) {
                    builder.put(param4, serializer4.write(context, p4));
                }
                if ((p5 = getter5.apply(value)) != null) {
                    builder.put(param5, serializer5.write(context, p5));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null, null, null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)), serializer3.read(context, compound.get(param3)), serializer4.read(context, compound.get(param4)), serializer5.read(context, compound.get(param5)));
            }
        };
    }

    @NotNull
    public static <P1, P2, P3, P4, P5, P6, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull String param3, final @NotNull BinaryTagSerializer<P3> serializer3, final @NotNull Function<R, P3> getter3, final @NotNull String param4, final @NotNull BinaryTagSerializer<P4> serializer4, final @NotNull Function<R, P4> getter4, final @NotNull String param5, final @NotNull BinaryTagSerializer<P5> serializer5, final @NotNull Function<R, P5> getter5, final @NotNull String param6, final @NotNull BinaryTagSerializer<P6> serializer6, final @NotNull Function<R, P6> getter6, final @NotNull Function6<P1, P2, P3, P4, P5, P6, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p6;
                Object p5;
                Object p4;
                Object p3;
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                if ((p3 = getter3.apply(value)) != null) {
                    builder.put(param3, serializer3.write(context, p3));
                }
                if ((p4 = getter4.apply(value)) != null) {
                    builder.put(param4, serializer4.write(context, p4));
                }
                if ((p5 = getter5.apply(value)) != null) {
                    builder.put(param5, serializer5.write(context, p5));
                }
                if ((p6 = getter6.apply(value)) != null) {
                    builder.put(param6, serializer6.write(context, p6));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null, null, null, null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)), serializer3.read(context, compound.get(param3)), serializer4.read(context, compound.get(param4)), serializer5.read(context, compound.get(param5)), serializer6.read(context, compound.get(param6)));
            }
        };
    }

    @NotNull
    public static <P1, P2, P3, P4, P5, P6, P7, R> BinaryTagSerializer<R> object(final @NotNull String param1, final @NotNull BinaryTagSerializer<P1> serializer1, final @NotNull Function<R, P1> getter1, final @NotNull String param2, final @NotNull BinaryTagSerializer<P2> serializer2, final @NotNull Function<R, P2> getter2, final @NotNull String param3, final @NotNull BinaryTagSerializer<P3> serializer3, final @NotNull Function<R, P3> getter3, final @NotNull String param4, final @NotNull BinaryTagSerializer<P4> serializer4, final @NotNull Function<R, P4> getter4, final @NotNull String param5, final @NotNull BinaryTagSerializer<P5> serializer5, final @NotNull Function<R, P5> getter5, final @NotNull String param6, final @NotNull BinaryTagSerializer<P6> serializer6, final @NotNull Function<R, P6> getter6, final @NotNull String param7, final @NotNull BinaryTagSerializer<P7> serializer7, final @NotNull Function<R, P7> getter7, final @NotNull Function7<P1, P2, P3, P4, P5, P6, P7, R> constructor) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object p7;
                Object p6;
                Object p5;
                Object p4;
                Object p3;
                Object p2;
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                Object p1 = getter1.apply(value);
                if (p1 != null) {
                    builder.put(param1, serializer1.write(context, p1));
                }
                if ((p2 = getter2.apply(value)) != null) {
                    builder.put(param2, serializer2.write(context, p2));
                }
                if ((p3 = getter3.apply(value)) != null) {
                    builder.put(param3, serializer3.write(context, p3));
                }
                if ((p4 = getter4.apply(value)) != null) {
                    builder.put(param4, serializer4.write(context, p4));
                }
                if ((p5 = getter5.apply(value)) != null) {
                    builder.put(param5, serializer5.write(context, p5));
                }
                if ((p6 = getter6.apply(value)) != null) {
                    builder.put(param6, serializer6.write(context, p6));
                }
                if ((p7 = getter7.apply(value)) != null) {
                    builder.put(param7, serializer7.write(context, p7));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return constructor.apply(null, null, null, null, null, null, null);
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return constructor.apply(serializer1.read(context, compound.get(param1)), serializer2.read(context, compound.get(param2)), serializer3.read(context, compound.get(param3)), serializer4.read(context, compound.get(param4)), serializer5.read(context, compound.get(param5)), serializer6.read(context, compound.get(param6)), serializer7.read(context, compound.get(param7)));
            }
        };
    }

    @NotNull
    public static <T> BinaryTagSerializer<T> registryTaggedUnion(final @NotNull Function<Registries, DynamicRegistry<BinaryTagSerializer<? extends T>>> registrySelector, final @NotNull Function<T, BinaryTagSerializer<? extends T>> serializerGetter, final @NotNull String key) {
        return new BinaryTagSerializer<T>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull T value) {
                Registries registries = Objects.requireNonNull(context.registries(), "No registries in context");
                DynamicRegistry registry = (DynamicRegistry)registrySelector.apply(registries);
                BinaryTagSerializer serializer = (BinaryTagSerializer)serializerGetter.apply(value);
                DynamicRegistry.Key<BinaryTagSerializer> type = registry.getKey(serializer);
                Check.notNull(type, "Unregistered serializer for: {0}", value);
                if (context.forClient() && registry.getPack(type) != DataPack.MINECRAFT_CORE) {
                    return null;
                }
                BinaryTag result = serializer.write(context, value);
                if (result == null) {
                    return null;
                }
                if (!(result instanceof CompoundBinaryTag)) {
                    throw new IllegalArgumentException("Expected compound tag for tagged union");
                }
                CompoundBinaryTag resultCompound = (CompoundBinaryTag)result;
                return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(resultCompound)).putString(key, type.name())).build();
            }

            @Override
            @NotNull
            public T read(@NotNull Context context, @NotNull BinaryTag tag) {
                Registries registries = Objects.requireNonNull(context.registries(), "No registries in context");
                DynamicRegistry registry = (DynamicRegistry)registrySelector.apply(registries);
                if (!(tag instanceof CompoundBinaryTag)) {
                    throw new IllegalArgumentException("Expected compound tag for tagged union");
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                String type = compound.getString(key);
                Check.argCondition(type.isEmpty(), "Missing {0} field: {1}", key, tag);
                BinaryTagSerializer serializer = (BinaryTagSerializer)registry.get(Key.key((String)type));
                Check.notNull(serializer, "Unregistered serializer for: {0}", type);
                return serializer.read(context, tag);
            }
        };
    }

    @NotNull
    default public BinaryTag write(@NotNull Context context, @NotNull T value) {
        return this.write(value);
    }

    @NotNull
    default public T read(@NotNull Context context, @NotNull BinaryTag tag) {
        return this.read(tag);
    }

    @NotNull
    default public BinaryTag write(@NotNull T value) {
        return this.write(Context.EMPTY, value);
    }

    @NotNull
    default public T read(@NotNull BinaryTag tag) {
        return this.read(Context.EMPTY, tag);
    }

    default public BinaryTagSerializer<@Nullable T> optional() {
        return this.optional(null);
    }

    default public BinaryTagSerializer<@UnknownNullability T> optional(final @Nullable T defaultValue) {
        return new BinaryTagSerializer<T>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @UnknownNullability T value) {
                return value == null || value.equals(defaultValue) ? null : BinaryTagSerializer.this.write(context, value);
            }

            @Override
            @NotNull
            public T read(@NotNull Context context, @NotNull BinaryTag tag) {
                return tag == null ? defaultValue : BinaryTagSerializer.this.read(context, tag);
            }
        };
    }

    default public <S> BinaryTagSerializer<S> map(final @NotNull Function<T, S> to, final @NotNull Function<S, T> from) {
        return new BinaryTagSerializer<S>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull S value) {
                return BinaryTagSerializer.this.write(context, from.apply(value));
            }

            @Override
            @NotNull
            public S read(@NotNull Context context, @NotNull BinaryTag tag) {
                return to.apply(BinaryTagSerializer.this.read(context, tag));
            }
        };
    }

    default public BinaryTagSerializer<List<T>> list() {
        return new BinaryTagSerializer<List<T>>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull List<T> value) {
                ListBinaryTag.Builder builder = ListBinaryTag.builder();
                for (Object t : value) {
                    BinaryTag entry = BinaryTagSerializer.this.write(context, t);
                    if (entry == null) continue;
                    builder.add(entry);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public List<T> read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof ListBinaryTag)) {
                    return List.of();
                }
                ListBinaryTag listBinaryTag = (ListBinaryTag)tag;
                ArrayList list = new ArrayList();
                for (BinaryTag element : listBinaryTag) {
                    list.add(BinaryTagSerializer.this.read(context, element));
                }
                return List.copyOf(list);
            }
        };
    }

    default public <V> BinaryTagSerializer<Map<T, V>> mapValue(final @NotNull BinaryTagSerializer<V> valueType) {
        return new BinaryTagSerializer<Map<T, V>>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull Map<T, V> value) {
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                for (Map.Entry entry : value.entrySet()) {
                    BinaryTag rawKey = BinaryTagSerializer.this.write(context, entry.getKey());
                    if (!(rawKey instanceof StringBinaryTag)) {
                        throw new IllegalArgumentException("Map key must be a string, got " + String.valueOf(rawKey));
                    }
                    StringBinaryTag keyTag = (StringBinaryTag)rawKey;
                    BinaryTag val = valueType.write(context, entry.getValue());
                    if (val == null) continue;
                    builder.put(keyTag.value(), val);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public Map<T, V> read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return Map.of();
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                HashMap map = new HashMap();
                for (Map.Entry entry : compound) {
                    Object key = BinaryTagSerializer.this.read(context, (BinaryTag)StringBinaryTag.stringBinaryTag((String)((String)entry.getKey())));
                    Object value = valueType.read(context, (BinaryTag)entry.getValue());
                    map.put(key, value);
                }
                return Map.copyOf(map);
            }
        };
    }

    default public <R> BinaryTagSerializer<R> unionType(@NotNull Function<T, BinaryTagSerializer<R>> serializers, @NotNull Function<R, T> keyFunc) {
        return this.unionType("type", serializers, keyFunc);
    }

    default public <R> BinaryTagSerializer<R> unionType(final @NotNull String keyField, final @NotNull Function<T, BinaryTagSerializer<R>> serializers, final @NotNull Function<R, T> keyFunc) {
        return new BinaryTagSerializer<R>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull Context context, @NotNull R value) {
                Object key = keyFunc.apply(value);
                Check.notNull(key, "unknown key: {0}", key);
                BinaryTagSerializer serializer = (BinaryTagSerializer)serializers.apply(key);
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                builder.put((CompoundBinaryTag)serializer.write(context, value));
                builder.put(keyField, BinaryTagSerializer.this.write(context, key));
                return builder.build();
            }

            @Override
            @NotNull
            public R read(@NotNull Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    return null;
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                Object key = BinaryTagSerializer.this.read(context, compound.get(keyField));
                Check.notNull(key, "unknown key: {0}", key);
                return ((BinaryTagSerializer)serializers.apply(key)).read(context, (BinaryTag)compound);
            }
        };
    }

    public static interface Function3<P1, P2, P3, R> {
        public R apply(P1 var1, P2 var2, P3 var3);
    }

    public static interface Function4<P1, P2, P3, P4, R> {
        public R apply(P1 var1, P2 var2, P3 var3, P4 var4);
    }

    public static interface Function5<P1, P2, P3, P4, P5, R> {
        public R apply(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5);
    }

    public static interface Function6<P1, P2, P3, P4, P5, P6, R> {
        public R apply(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6);
    }

    public static interface Function7<P1, P2, P3, P4, P5, P6, P7, R> {
        public R apply(P1 var1, P2 var2, P3 var3, P4 var4, P5 var5, P6 var6, P7 var7);
    }

    public static interface Context {
        public static final Context EMPTY = new Context(){

            @Override
            @Nullable
            public Registries registries() {
                return null;
            }

            @Override
            public boolean forClient() {
                return false;
            }
        };

        @Nullable
        public Registries registries();

        public boolean forClient();
    }

    public record ContextWithRegistries(@NotNull Registries registries, boolean forClient) implements Context
    {
        public ContextWithRegistries(@NotNull Registries registries) {
            this(registries, false);
        }
    }
}

