/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.collection;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AutoIncrementMap<K> {
    private final Object2IntOpenHashMap<K> write = new Object2IntOpenHashMap();
    private Object2IntOpenHashMap<K> read;
    private int lastIndex;

    public AutoIncrementMap() {
        this.write.defaultReturnValue(-1);
        this.read = this.write.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(pure=true)
    public int get(@NotNull K key) {
        int index = this.read.getInt(key);
        if (index == -1) {
            Object2IntOpenHashMap<K> object2IntOpenHashMap = this.write;
            synchronized (object2IntOpenHashMap) {
                Object2IntOpenHashMap<K> write = this.write;
                index = write.getInt(key);
                if (index == -1) {
                    index = this.lastIndex++;
                    write.put(key, index);
                    this.read = write.clone();
                }
            }
        }
        return index;
    }
}

