/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.arguments.minecraft.ArgumentIntRange;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Range;
import net.minestom.server.utils.entity.EntityFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentEntity
extends Argument<EntityFinder> {
    public static final int INVALID_SYNTAX = -2;
    public static final int ONLY_SINGLE_ENTITY_ERROR = -3;
    public static final int ONLY_PLAYERS_ERROR = -4;
    public static final int INVALID_ARGUMENT_NAME = -5;
    public static final int INVALID_ARGUMENT_VALUE = -6;
    private static final Pattern USERNAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]{1,16}");
    private static final String SELECTOR_PREFIX = "@";
    private static final List<String> SELECTOR_VARIABLES = Arrays.asList("@p", "@r", "@a", "@e", "@s", "@n");
    private static final List<String> PLAYERS_ONLY_SELECTOR = Arrays.asList("@p", "@r", "@a", "@s");
    private static final List<String> SINGLE_ONLY_SELECTOR = Arrays.asList("@p", "@r", "@s", "@n");
    private static final List<String> VALID_ARGUMENTS = Arrays.asList("x", "y", "z", "distance", "dx", "dy", "dz", "scores", "tag", "team", "limit", "sort", "level", "gamemode", "name", "x_rotation", "y_rotation", "type", "nbt", "advancements", "predicate");
    private static final List<String> SIMPLE_ARGUMENTS = Arrays.asList("x", "y", "z", "distance", "dx", "dy", "dz", "scores", "tag", "team", "limit", "sort", "level", "gamemode", "x_rotation", "y_rotation", "type", "advancements", "predicate");
    private boolean onlySingleEntity;
    private boolean onlyPlayers;

    public ArgumentEntity(String id) {
        super(id, true);
    }

    public ArgumentEntity singleEntity(boolean singleEntity) {
        this.onlySingleEntity = singleEntity;
        return this;
    }

    public ArgumentEntity onlyPlayers(boolean onlyPlayers) {
        this.onlyPlayers = onlyPlayers;
        return this;
    }

    @Override
    @NotNull
    public EntityFinder parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        return ArgumentEntity.staticParse(sender, input, this.onlySingleEntity, this.onlyPlayers);
    }

    @Override
    public ArgumentParserType parser() {
        return ArgumentParserType.ENTITY;
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return NetworkBuffer.makeArray(buffer -> {
            byte mask = 0;
            if (this.isOnlySingleEntity()) {
                mask = (byte)(mask | 1);
            }
            if (this.isOnlyPlayers()) {
                mask = (byte)(mask | 2);
            }
            buffer.write(NetworkBuffer.BYTE, mask);
        });
    }

    @Deprecated
    @NotNull
    public static EntityFinder staticParse(@NotNull CommandSender sender, @NotNull String input, boolean onlySingleEntity, boolean onlyPlayers) throws ArgumentSyntaxException {
        block9: {
            if (!input.contains(SELECTOR_PREFIX) && !input.contains(" ")) {
                try {
                    UUID uuid = UUID.fromString(input);
                    return new EntityFinder().setTargetSelector(EntityFinder.TargetSelector.MINESTOM_UUID).setConstantUuid(uuid);
                }
                catch (IllegalArgumentException uuid) {
                    if (!USERNAME_PATTERN.matcher(input).matches()) break block9;
                    return new EntityFinder().setTargetSelector(EntityFinder.TargetSelector.MINESTOM_USERNAME).setConstantName(input);
                }
            }
        }
        if (input.length() < 2) {
            throw new ArgumentSyntaxException("Length needs to be > 1", input, -2);
        }
        if (!input.startsWith(SELECTOR_PREFIX)) {
            throw new ArgumentSyntaxException("Target selector needs to start with @", input, -2);
        }
        String selectorVariable = input.substring(0, 2);
        if (!SELECTOR_VARIABLES.contains(selectorVariable)) {
            throw new ArgumentSyntaxException("Invalid selector variable", input, -2);
        }
        if (onlySingleEntity && !SINGLE_ONLY_SELECTOR.contains(selectorVariable)) {
            throw new ArgumentSyntaxException("Argument requires only a single entity", input, -3);
        }
        if (onlyPlayers && !PLAYERS_ONLY_SELECTOR.contains(selectorVariable)) {
            throw new ArgumentSyntaxException("Argument requires only players", input, -4);
        }
        EntityFinder entityFinder = new EntityFinder().setTargetSelector(ArgumentEntity.toTargetSelector(selectorVariable));
        if (input.length() == 2) {
            return entityFinder;
        }
        String structure = input.substring(2);
        return ArgumentEntity.parseStructure(sender, input, entityFinder, structure);
    }

    @NotNull
    private static EntityFinder parseStructure(@NotNull CommandSender sender, @NotNull String input, @NotNull EntityFinder entityFinder, @NotNull String structure) throws ArgumentSyntaxException {
        if (!structure.startsWith("[") || !structure.endsWith("]")) {
            throw new ArgumentSyntaxException("Target selector needs to start and end with brackets", input, -2);
        }
        String structureData = structure.substring(1, structure.length() - 1);
        Object currentArgument = "";
        for (int i = 0; i < structureData.length(); ++i) {
            char c = structureData.charAt(i);
            if (c == '=') {
                if (!VALID_ARGUMENTS.contains(currentArgument = ((String)currentArgument).trim())) {
                    throw new ArgumentSyntaxException("Argument name '" + (String)currentArgument + "' does not exist", input, -5);
                }
                i = ArgumentEntity.parseArgument(sender, entityFinder, (String)currentArgument, input, structureData, i);
                currentArgument = "";
                continue;
            }
            currentArgument = (String)currentArgument + c;
        }
        return entityFinder;
    }

    private static int parseArgument(@NotNull CommandSender sender, @NotNull EntityFinder entityFinder, @NotNull String argumentName, @NotNull String input, @NotNull String structureData, int beginIndex) throws ArgumentSyntaxException {
        int finalIndex;
        int comma = 44;
        boolean isSimple = SIMPLE_ARGUMENTS.contains(argumentName);
        StringBuilder valueBuilder = new StringBuilder();
        for (finalIndex = beginIndex + 1; finalIndex < structureData.length(); ++finalIndex) {
            char c = structureData.charAt(finalIndex);
            if (isSimple && c == ',') break;
            valueBuilder.append(c);
        }
        String value = valueBuilder.toString().trim();
        switch (argumentName) {
            case "type": {
                boolean include = !value.startsWith("!");
                String entityName = include ? value : value.substring(1);
                EntityType entityType = EntityType.fromKey(entityName);
                if (entityType == null) {
                    throw new ArgumentSyntaxException("Invalid entity name", input, -6);
                }
                entityFinder.setEntity(entityType, include ? EntityFinder.ToggleableType.INCLUDE : EntityFinder.ToggleableType.EXCLUDE);
                break;
            }
            case "gamemode": {
                boolean include = !value.startsWith("!");
                String gameModeName = include ? value : value.substring(1);
                try {
                    GameMode gameMode = GameMode.valueOf(gameModeName.toUpperCase());
                    entityFinder.setGameMode(gameMode, include ? EntityFinder.ToggleableType.INCLUDE : EntityFinder.ToggleableType.EXCLUDE);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ArgumentSyntaxException("Invalid entity game mode", input, -6);
                }
            }
            case "limit": {
                int limit;
                try {
                    limit = Integer.parseInt(value);
                    entityFinder.setLimit(limit);
                }
                catch (NumberFormatException e) {
                    throw new ArgumentSyntaxException("Invalid limit number", input, -6);
                }
                if (limit > 0) break;
                throw new ArgumentSyntaxException("Limit must be positive", input, -6);
            }
            case "sort": {
                try {
                    EntityFinder.EntitySort entitySort = EntityFinder.EntitySort.valueOf(value.toUpperCase());
                    entityFinder.setEntitySort(entitySort);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new ArgumentSyntaxException("Invalid entity sort", input, -6);
                }
            }
            case "level": {
                try {
                    Range.Int level = Argument.parse(sender, new ArgumentIntRange(value));
                    entityFinder.setLevel(level);
                    break;
                }
                catch (ArgumentSyntaxException e) {
                    throw new ArgumentSyntaxException("Invalid level number", input, -6);
                }
            }
            case "distance": {
                try {
                    Range.Int distance = Argument.parse(sender, new ArgumentIntRange(value));
                    entityFinder.setDistance(distance);
                    break;
                }
                catch (ArgumentSyntaxException e) {
                    throw new ArgumentSyntaxException("Invalid level number", input, -6);
                }
            }
        }
        return finalIndex;
    }

    public boolean isOnlySingleEntity() {
        return this.onlySingleEntity;
    }

    public boolean isOnlyPlayers() {
        return this.onlyPlayers;
    }

    public String toString() {
        if (this.onlySingleEntity) {
            if (this.onlyPlayers) {
                return String.format("Player<%s>", this.getId());
            }
            return String.format("Entity<%s>", this.getId());
        }
        if (this.onlyPlayers) {
            return String.format("Players<%s>", this.getId());
        }
        return String.format("Entities<%s>", this.getId());
    }

    private static EntityFinder.TargetSelector toTargetSelector(@NotNull String selectorVariable) {
        if (selectorVariable.equals("@p")) {
            return EntityFinder.TargetSelector.NEAREST_PLAYER;
        }
        if (selectorVariable.equals("@n")) {
            return EntityFinder.TargetSelector.NEAREST_ENTITY;
        }
        if (selectorVariable.equals("@r")) {
            return EntityFinder.TargetSelector.RANDOM_PLAYER;
        }
        if (selectorVariable.equals("@a")) {
            return EntityFinder.TargetSelector.ALL_PLAYERS;
        }
        if (selectorVariable.equals("@e")) {
            return EntityFinder.TargetSelector.ALL_ENTITIES;
        }
        if (selectorVariable.equals("@s")) {
            return EntityFinder.TargetSelector.SELF;
        }
        throw new IllegalStateException("Weird selector variable: " + selectorVariable);
    }
}

