package net.minestom.server.recipe;

import net.kyori.adventure.key.Key;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by RecipeTypeGenerator
 */
public enum RecipeType implements StaticProtocolObject {
    CRAFTING(Key.key("minecraft:crafting")),

    SMELTING(Key.key("minecraft:smelting")),

    BLASTING(Key.key("minecraft:blasting")),

    SMOKING(Key.key("minecraft:smoking")),

    CAMPFIRE_COOKING(Key.key("minecraft:campfire_cooking")),

    STONECUTTING(Key.key("minecraft:stonecutting")),

    SMITHING(Key.key("minecraft:smithing"));

    public static final NetworkBuffer.Type<RecipeType> NETWORK_TYPE = NetworkBuffer.Enum(RecipeType.class);

    public static final BinaryTagSerializer<RecipeType> NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(RecipeType.class);

    private final Key key;

    RecipeType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
