package net.minestom.server.entity;

import net.kyori.adventure.key.Key;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum VillagerType implements StaticProtocolObject {
    DESERT(Key.key("minecraft:desert")),

    JUNGLE(Key.key("minecraft:jungle")),

    PLAINS(Key.key("minecraft:plains")),

    SAVANNA(Key.key("minecraft:savanna")),

    SNOW(Key.key("minecraft:snow")),

    SWAMP(Key.key("minecraft:swamp")),

    TAIGA(Key.key("minecraft:taiga"));

    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);

    public static final BinaryTagSerializer<VillagerType> NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(VillagerType.class);

    private final Key key;

    VillagerType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
