/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

sealed interface ObjectSetImpl<T extends ProtocolObject>
extends ObjectSet<T> {

    public record NbtType<T extends ProtocolObject>(@NotNull Tag.BasicType tagType) implements BinaryTagSerializer<ObjectSet<T>>
    {
        @Override
        @NotNull
        public ObjectSet<T> read(@NotNull BinaryTag tag) {
            BinaryTag binaryTag = tag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListBinaryTag.class, StringBinaryTag.class}, (Object)binaryTag, n)) {
                case -1 -> ObjectSet.empty();
                case 0 -> {
                    ListBinaryTag list = (ListBinaryTag)binaryTag;
                    if (list.size() == 0) {
                        yield ObjectSet.empty();
                    }
                    ArrayList<NamespaceID> entries = new ArrayList<NamespaceID>(list.size());
                    for (BinaryTag entryTag : list) {
                        if (!(entryTag instanceof StringBinaryTag)) {
                            throw new IllegalArgumentException("Invalid entry type: " + String.valueOf(entryTag.type()));
                        }
                        StringBinaryTag stringTag = (StringBinaryTag)entryTag;
                        entries.add(NamespaceID.from(stringTag.value()));
                    }
                    yield new Entries(entries);
                }
                case 1 -> {
                    StringBinaryTag string = (StringBinaryTag)binaryTag;
                    String value = string.value();
                    if (value.startsWith("#")) {
                        yield new Tag(this.tagType(), value.substring(1));
                    }
                    yield new Entries(List.of(NamespaceID.from(value)));
                }
                default -> throw new IllegalArgumentException("Invalid tag type: " + String.valueOf(tag.type()));
            };
        }

        @Override
        @NotNull
        public BinaryTag write(@NotNull ObjectSet<T> value) {
            ObjectSet<T> objectSet = value;
            Objects.requireNonNull(objectSet);
            ObjectSet<T> objectSet2 = objectSet;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, Entries.class, Tag.class}, objectSet2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Empty empty = (Empty)objectSet2;
                    yield ListBinaryTag.empty();
                }
                case 1 -> {
                    Entries entries = (Entries)objectSet2;
                    if (entries.entries.size() == 1) {
                        yield StringBinaryTag.stringBinaryTag((String)((NamespaceID)entries.entries.stream().findFirst().get()).asString());
                    }
                    ListBinaryTag.Builder builder = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.STRING);
                    for (NamespaceID entry : entries.entries) {
                        builder.add((BinaryTag)StringBinaryTag.stringBinaryTag((String)entry.asString()));
                    }
                    yield builder.build();
                }
                case 2 -> {
                    Tag tag = (Tag)objectSet2;
                    yield StringBinaryTag.stringBinaryTag((String)("#" + tag.name()));
                }
            };
        }
    }

    public record NetworkType<T extends ProtocolObject>(@NotNull Tag.BasicType tagType) implements NetworkBuffer.Type<ObjectSet<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, ObjectSet<T> value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public ObjectSet<T> read(@NotNull NetworkBuffer buffer) {
            throw new UnsupportedOperationException("todo");
        }
    }

    public static final class Tag<T extends ProtocolObject>
    implements ObjectSetImpl<T> {
        private final Tag.BasicType tagType;
        private final String name;
        private volatile Set<NamespaceID> value = null;

        public Tag(@NotNull Tag.BasicType tagType, @NotNull String name) {
            this.tagType = tagType;
            this.name = name;
        }

        public Tag(@NotNull net.minestom.server.gamedata.tags.Tag tag) {
            this.tagType = null;
            this.name = tag.name();
            this.value = Set.copyOf(tag.getValues());
        }

        @NotNull
        public String name() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<NamespaceID> value() {
            if (this.value == null) {
                Tag tag = this;
                synchronized (tag) {
                    if (this.value == null) {
                        net.minestom.server.gamedata.tags.Tag group = MinecraftServer.getTagManager().getTag(this.tagType, this.name);
                        this.value = group == null ? Set.of() : Set.copyOf(group.getValues());
                    }
                }
            }
            return this.value;
        }

        @Override
        public boolean contains(@NotNull NamespaceID namespace) {
            return this.value().contains(namespace);
        }
    }

    public record Entries<T extends ProtocolObject>(@NotNull List<NamespaceID> entries) implements ObjectSetImpl<T>
    {
        public Entries(@NotNull List<NamespaceID> entries) {
            entries = List.copyOf(entries);
        }

        @Override
        public boolean contains(@NotNull NamespaceID namespace) {
            return this.entries.contains(namespace);
        }
    }

    public record Empty<T extends ProtocolObject>() implements ObjectSetImpl<T>
    {
        static final Empty<?> INSTANCE = new Empty();

        @Override
        public boolean contains(@NotNull NamespaceID namespace) {
            return false;
        }
    }
}

