/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.recipe.display.RecipeDisplayType;
import net.minestom.server.recipe.display.SlotDisplay;
import org.jetbrains.annotations.NotNull;

public sealed interface RecipeDisplay {
    @NotNull
    public static final NetworkBuffer.Type<RecipeDisplay> NETWORK_TYPE = RecipeDisplayType.NETWORK_TYPE.unionType(RecipeDisplay::dataSerializer, RecipeDisplay::recipeDisplayToType);

    private static NetworkBuffer.Type<RecipeDisplay> dataSerializer(@NotNull RecipeDisplayType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RecipeDisplayType.CRAFTING_SHAPELESS -> CraftingShapeless.NETWORK_TYPE;
            case RecipeDisplayType.CRAFTING_SHAPED -> CraftingShaped.NETWORK_TYPE;
            case RecipeDisplayType.FURNACE -> Furnace.NETWORK_TYPE;
            case RecipeDisplayType.STONECUTTER -> Stonecutter.NETWORK_TYPE;
            case RecipeDisplayType.SMITHING -> Smithing.NETWORK_TYPE;
        };
    }

    private static RecipeDisplayType recipeDisplayToType(@NotNull RecipeDisplay recipeDisplay) {
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        Objects.requireNonNull(recipeDisplay2);
        RecipeDisplay recipeDisplay3 = recipeDisplay2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CraftingShapeless.class, CraftingShaped.class, Furnace.class, Stonecutter.class, Smithing.class}, (Object)recipeDisplay3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                CraftingShapeless ignored = (CraftingShapeless)recipeDisplay3;
                yield RecipeDisplayType.CRAFTING_SHAPELESS;
            }
            case 1 -> {
                CraftingShaped ignored = (CraftingShaped)recipeDisplay3;
                yield RecipeDisplayType.CRAFTING_SHAPED;
            }
            case 2 -> {
                Furnace ignored = (Furnace)recipeDisplay3;
                yield RecipeDisplayType.FURNACE;
            }
            case 3 -> {
                Stonecutter ignored = (Stonecutter)recipeDisplay3;
                yield RecipeDisplayType.STONECUTTER;
            }
            case 4 -> {
                Smithing ignored = (Smithing)recipeDisplay3;
                yield RecipeDisplayType.SMITHING;
            }
        };
    }

    public record CraftingShapeless(@NotNull List<SlotDisplay> ingredients, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation) implements RecipeDisplay
    {
        private static final int MAX_INGREDIENTS = Short.MAX_VALUE;
        public static final NetworkBuffer.Type<CraftingShapeless> NETWORK_TYPE = NetworkBufferTemplate.template(SlotDisplay.NETWORK_TYPE.list(Short.MAX_VALUE), CraftingShapeless::ingredients, SlotDisplay.NETWORK_TYPE, CraftingShapeless::result, SlotDisplay.NETWORK_TYPE, CraftingShapeless::craftingStation, CraftingShapeless::new);
    }

    public record CraftingShaped(int width, int height, @NotNull List<SlotDisplay> ingredients, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation) implements RecipeDisplay
    {
        private static final int MAX_INGREDIENTS = Short.MAX_VALUE;
        public static final NetworkBuffer.Type<CraftingShaped> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, CraftingShaped::width, NetworkBuffer.VAR_INT, CraftingShaped::height, SlotDisplay.NETWORK_TYPE.list(Short.MAX_VALUE), CraftingShaped::ingredients, SlotDisplay.NETWORK_TYPE, CraftingShaped::result, SlotDisplay.NETWORK_TYPE, CraftingShaped::craftingStation, CraftingShaped::new);

        public CraftingShaped(int width, int height, @NotNull List<SlotDisplay> ingredients, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation) {
            if (ingredients.size() != width * height) {
                throw new IllegalArgumentException("Invalid shaped recipe, ingredients size must be equal to width * height");
            }
            ingredients = List.copyOf(ingredients);
        }
    }

    public record Furnace(@NotNull SlotDisplay ingredient, @NotNull SlotDisplay fuel, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation, int duration, float experience) implements RecipeDisplay
    {
        public static final NetworkBuffer.Type<Furnace> NETWORK_TYPE = NetworkBufferTemplate.template(SlotDisplay.NETWORK_TYPE, Furnace::ingredient, SlotDisplay.NETWORK_TYPE, Furnace::fuel, SlotDisplay.NETWORK_TYPE, Furnace::result, SlotDisplay.NETWORK_TYPE, Furnace::craftingStation, NetworkBuffer.VAR_INT, Furnace::duration, NetworkBuffer.FLOAT, Furnace::experience, Furnace::new);
    }

    public record Stonecutter(@NotNull SlotDisplay ingredient, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation) implements RecipeDisplay
    {
        public static final NetworkBuffer.Type<Stonecutter> NETWORK_TYPE = NetworkBufferTemplate.template(SlotDisplay.NETWORK_TYPE, Stonecutter::ingredient, SlotDisplay.NETWORK_TYPE, Stonecutter::result, SlotDisplay.NETWORK_TYPE, Stonecutter::craftingStation, Stonecutter::new);
    }

    public record Smithing(@NotNull SlotDisplay template, @NotNull SlotDisplay base, @NotNull SlotDisplay addition, @NotNull SlotDisplay result, @NotNull SlotDisplay craftingStation) implements RecipeDisplay
    {
        public static final NetworkBuffer.Type<Smithing> NETWORK_TYPE = NetworkBufferTemplate.template(SlotDisplay.NETWORK_TYPE, Smithing::template, SlotDisplay.NETWORK_TYPE, Smithing::base, SlotDisplay.NETWORK_TYPE, Smithing::addition, SlotDisplay.NETWORK_TYPE, Smithing::result, SlotDisplay.NETWORK_TYPE, Smithing::craftingStation, Smithing::new);
    }
}

