/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<EntityEquipmentPacket> SERIALIZER = new NetworkBuffer.Type<EntityEquipmentPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, EntityEquipmentPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            int index = 0;
            for (Map.Entry<EquipmentSlot, ItemStack> entry : value.equipments.entrySet()) {
                boolean last = index++ == value.equipments.size() - 1;
                byte slotEnum = (byte)entry.getKey().ordinal();
                if (!last) {
                    slotEnum = (byte)(slotEnum | 0x80);
                }
                buffer.write(NetworkBuffer.BYTE, slotEnum);
                buffer.write(ItemStack.NETWORK_TYPE, entry.getValue());
            }
        }

        @Override
        public EntityEquipmentPacket read(@NotNull NetworkBuffer buffer) {
            return new EntityEquipmentPacket(buffer.read(NetworkBuffer.VAR_INT), EntityEquipmentPacket.readEquipments(buffer));
        }
    };

    public EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) {
        equipments = Map.copyOf(equipments);
        if (equipments.isEmpty()) {
            throw new IllegalArgumentException("Equipments cannot be empty");
        }
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return this.equipments.values().stream().map(item -> item.get(ItemComponent.CUSTOM_NAME)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        EnumMap<EquipmentSlot, ItemStack> map = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        this.equipments.forEach((key, value) -> map.put((EquipmentSlot)((Object)key), value.with(ItemComponent.CUSTOM_NAME, operator)));
        return new EntityEquipmentPacket(this.entityId, map);
    }

    private static Map<EquipmentSlot, ItemStack> readEquipments(@NotNull NetworkBuffer reader) {
        byte slot;
        EnumMap<EquipmentSlot, ItemStack> equipments = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        do {
            slot = reader.read(NetworkBuffer.BYTE);
            equipments.put(EquipmentSlot.values()[slot & 0x7F], reader.read(ItemStack.NETWORK_TYPE));
        } while ((slot & 0x80) == 128);
        return equipments;
    }
}

