/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.book;

import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FilteredText<T>(@NotNull T text, @Nullable T filtered) {
    @NotNull
    public static NetworkBuffer.Type<FilteredText<String>> STRING_NETWORK_TYPE = FilteredText.createNetworkType(NetworkBuffer.STRING);
    @NotNull
    public static BinaryTagSerializer<FilteredText<String>> STRING_NBT_TYPE = FilteredText.createNbtType(BinaryTagSerializer.STRING);
    @NotNull
    public static NetworkBuffer.Type<FilteredText<Component>> COMPONENT_NETWORK_TYPE = FilteredText.createNetworkType(NetworkBuffer.COMPONENT);
    @NotNull
    public static BinaryTagSerializer<FilteredText<Component>> COMPONENT_NBT_TYPE = FilteredText.createNbtType(BinaryTagSerializer.JSON_COMPONENT);

    private static <T> @NotNull NetworkBuffer.Type<FilteredText<T>> createNetworkType(final @NotNull NetworkBuffer.Type<T> inner) {
        return new NetworkBuffer.Type<FilteredText<T>>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, FilteredText<T> value) {
                buffer.write(inner, value.text);
                buffer.write(inner.optional(), value.filtered);
            }

            @Override
            public FilteredText<T> read(@NotNull NetworkBuffer buffer) {
                return new FilteredText(buffer.read(inner), buffer.read(inner.optional()));
            }
        };
    }

    @NotNull
    private static <T> BinaryTagSerializer<FilteredText<T>> createNbtType(final @NotNull BinaryTagSerializer<T> inner) {
        return new BinaryTagSerializer<FilteredText<T>>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull FilteredText<T> value) {
                CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
                builder.put("text", inner.write(value.text));
                if (value.filtered != null) {
                    builder.put("filtered", inner.write(value.filtered));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public FilteredText<T> read(@NotNull BinaryTag tag) {
                CompoundBinaryTag compound;
                BinaryTag textTag;
                if (tag instanceof CompoundBinaryTag && (textTag = (compound = (CompoundBinaryTag)tag).get("text")) != null) {
                    BinaryTag filteredTag = compound.get("filtered");
                    Object filtered = filteredTag == null ? null : (Object)inner.read(filteredTag);
                    return new FilteredText<Object>(inner.read(textTag), filtered);
                }
                return new FilteredText<Object>(inner.read(tag), null);
            }
        };
    }
}

