/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water.fish;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.water.fish.AbstractFishMeta;
import org.jetbrains.annotations.NotNull;

public class SalmonMeta
extends AbstractFishMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 17;

    public SalmonMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.BY_ID.getOrDefault(this.metadata.getIndex(17, ""), Variant.MEDIUM);
    }

    public static enum Variant {
        SMALL("small"),
        MEDIUM("medium"),
        LARGE("large");

        private static final Map<String, Variant> BY_ID;
        private final String id;

        private Variant(String id) {
            this.id = id;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        static {
            BY_ID = Arrays.stream(Variant.values()).collect(Collectors.toMap(Variant::id, variant -> variant));
        }
    }
}

