/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.water.AgeableWaterAnimalMeta;
import org.jetbrains.annotations.NotNull;

public class DolphinMeta
extends AgeableWaterAnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 20;

    public DolphinMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Point getTreasurePosition() {
        return this.metadata.getIndex(17, Vec.ZERO);
    }

    public void setTreasurePosition(@NotNull Point value) {
        this.metadata.setIndex(17, Metadata.BlockPosition(value));
    }

    public boolean isHasFish() {
        return this.metadata.getIndex(18, false);
    }

    public void setHasFish(boolean value) {
        this.metadata.setIndex(18, Metadata.Boolean(value));
    }

    public int getMoistureLevel() {
        return this.metadata.getIndex(19, 2400);
    }

    public void setMoistureLevel(int value) {
        this.metadata.setIndex(19, Metadata.VarInt(value));
    }
}

