/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public enum GameMode {
    SURVIVAL(false, false, false),
    CREATIVE(true, true, true),
    ADVENTURE(false, false, false),
    SPECTATOR(true, true, false);

    private final boolean allowFlying;
    private final boolean invulnerable;
    private final boolean instantBreak;
    private static final GameMode[] VALUES;
    public static final NetworkBuffer.Type<GameMode> NETWORK_TYPE;
    public static final NetworkBuffer.Type<GameMode> OPT_NETWORK_TYPE;

    private GameMode(boolean allowFlying, boolean invulnerable, boolean instantBreak) {
        this.allowFlying = allowFlying;
        this.invulnerable = invulnerable;
        this.instantBreak = instantBreak;
    }

    public boolean allowFlying() {
        return this.allowFlying;
    }

    public boolean canTakeDamage() {
        return this.invulnerable;
    }

    public boolean instantBreak() {
        return this.instantBreak;
    }

    static {
        VALUES = GameMode.values();
        NETWORK_TYPE = NetworkBuffer.BYTE.transform(id -> VALUES[id], gameMode -> (byte)gameMode.ordinal());
        OPT_NETWORK_TYPE = new NetworkBuffer.Type<GameMode>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, GameMode value) {
                buffer.write(NetworkBuffer.BYTE, value != null ? (byte)value.ordinal() : (byte)-1);
            }

            @Override
            public GameMode read(@NotNull NetworkBuffer buffer) {
                byte id = buffer.read(NetworkBuffer.BYTE);
                return id != -1 ? VALUES[id] : null;
            }
        };
    }
}

