/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeCategory;
import net.minestom.server.recipe.RecipeType;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RecipeSerializers {
    public static final NetworkBuffer.Type<Recipe.Data> DATA = RecipeType.NETWORK_TYPE.unionType(RecipeSerializers::dataSerializer, RecipeSerializers::recipeToType);
    public static final NetworkBuffer.Type<Recipe> RECIPE = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe::id, DATA, Recipe::data, Recipe::new);
    public static final NetworkBuffer.Type<Recipe.Ingredient> INGREDIENT = NetworkBufferTemplate.template(new NetworkBuffer.Type<List<Material>>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, List<Material> value) {
            buffer.write(NetworkBuffer.VAR_INT, value.size() + 1);
            for (Material material : value) {
                buffer.write(Material.NETWORK_TYPE, material);
            }
        }

        @Override
        public List<Material> read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT) - 1;
            Check.notNull(size > Short.MAX_VALUE, "too many ingredients");
            if (size == -1) {
                throw new UnsupportedOperationException("cannot read ingredient tags yet");
            }
            ArrayList<Material> materials = new ArrayList<Material>(size);
            for (int i = 0; i < size; ++i) {
                materials.add(buffer.read(Material.NETWORK_TYPE));
            }
            return materials;
        }
    }, Recipe.Ingredient::items, Recipe.Ingredient::new);
    public static final NetworkBuffer.Type<Recipe.Shaped> SHAPED = new NetworkBuffer.Type<Recipe.Shaped>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, Recipe.Shaped shaped) {
            buffer.write(NetworkBuffer.STRING, shaped.group());
            buffer.write(NetworkBuffer.Enum(RecipeCategory.Crafting.class), shaped.category());
            buffer.write(NetworkBuffer.VAR_INT, shaped.width());
            buffer.write(NetworkBuffer.VAR_INT, shaped.height());
            for (Recipe.Ingredient ingredient : shaped.ingredients()) {
                buffer.write(INGREDIENT, ingredient);
            }
            buffer.write(ItemStack.STRICT_NETWORK_TYPE, shaped.result());
            buffer.write(NetworkBuffer.BOOLEAN, shaped.showNotification());
        }

        @Override
        public Recipe.Shaped read(@NotNull NetworkBuffer buffer) {
            String group = buffer.read(NetworkBuffer.STRING);
            RecipeCategory.Crafting category = buffer.read(NetworkBuffer.Enum(RecipeCategory.Crafting.class));
            int width = buffer.read(NetworkBuffer.VAR_INT);
            int height = buffer.read(NetworkBuffer.VAR_INT);
            ArrayList<Recipe.Ingredient> ingredients = new ArrayList<Recipe.Ingredient>();
            for (int slot = 0; slot < width * height; ++slot) {
                ingredients.add(buffer.read(INGREDIENT));
            }
            ItemStack result = buffer.read(ItemStack.STRICT_NETWORK_TYPE);
            boolean showNotification = buffer.read(NetworkBuffer.BOOLEAN);
            return new Recipe.Shaped(group, category, width, height, ingredients, result, showNotification);
        }
    };
    public static final NetworkBuffer.Type<Recipe.Shapeless> SHAPELESS = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Shapeless::group, NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.Shapeless::category, INGREDIENT.list(128), Recipe.Shapeless::ingredients, ItemStack.STRICT_NETWORK_TYPE, Recipe.Shapeless::result, Recipe.Shapeless::new);
    public static final NetworkBuffer.Type<Recipe.Smelting> SMELTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Smelting::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Smelting::category, INGREDIENT, Recipe.Smelting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Smelting::result, NetworkBuffer.FLOAT, Recipe.Smelting::experience, NetworkBuffer.VAR_INT, Recipe.Smelting::cookingTime, Recipe.Smelting::new);
    public static final NetworkBuffer.Type<Recipe.Blasting> BLASTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Blasting::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Blasting::category, INGREDIENT, Recipe.Blasting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Blasting::result, NetworkBuffer.FLOAT, Recipe.Blasting::experience, NetworkBuffer.VAR_INT, Recipe.Blasting::cookingTime, Recipe.Blasting::new);
    public static final NetworkBuffer.Type<Recipe.Smoking> SMOKING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Smoking::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Smoking::category, INGREDIENT, Recipe.Smoking::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Smoking::result, NetworkBuffer.FLOAT, Recipe.Smoking::experience, NetworkBuffer.VAR_INT, Recipe.Smoking::cookingTime, Recipe.Smoking::new);
    public static final NetworkBuffer.Type<Recipe.CampfireCooking> CAMPFIRE_COOKING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.CampfireCooking::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.CampfireCooking::category, INGREDIENT, Recipe.CampfireCooking::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.CampfireCooking::result, NetworkBuffer.FLOAT, Recipe.CampfireCooking::experience, NetworkBuffer.VAR_INT, Recipe.CampfireCooking::cookingTime, Recipe.CampfireCooking::new);
    public static final NetworkBuffer.Type<Recipe.Stonecutting> STONECUTTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Stonecutting::group, INGREDIENT, Recipe.Stonecutting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Stonecutting::result, Recipe.Stonecutting::new);
    public static final NetworkBuffer.Type<Recipe.SmithingTransform> SMITHING_TRANSFORM = NetworkBufferTemplate.template(INGREDIENT, Recipe.SmithingTransform::template, INGREDIENT, Recipe.SmithingTransform::base, INGREDIENT, Recipe.SmithingTransform::addition, ItemStack.STRICT_NETWORK_TYPE, Recipe.SmithingTransform::result, Recipe.SmithingTransform::new);
    public static final NetworkBuffer.Type<Recipe.SmithingTrim> SMITHING_TRIM = NetworkBufferTemplate.template(INGREDIENT, Recipe.SmithingTrim::template, INGREDIENT, Recipe.SmithingTrim::base, INGREDIENT, Recipe.SmithingTrim::addition, Recipe.SmithingTrim::new);
    public static final NetworkBuffer.Type<Recipe.SpecialArmorDye> ARMOR_DYE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialArmorDye::category, Recipe.SpecialArmorDye::new);
    public static final NetworkBuffer.Type<Recipe.SpecialBookCloning> BOOK_CLONING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialBookCloning::category, Recipe.SpecialBookCloning::new);
    public static final NetworkBuffer.Type<Recipe.SpecialMapCloning> MAP_CLONING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialMapCloning::category, Recipe.SpecialMapCloning::new);
    public static final NetworkBuffer.Type<Recipe.SpecialMapExtending> MAP_EXTENDING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialMapExtending::category, Recipe.SpecialMapExtending::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkRocket> FIREWORK_ROCKET = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkRocket::category, Recipe.SpecialFireworkRocket::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkStar> FIREWORK_STAR = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkStar::category, Recipe.SpecialFireworkStar::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkStarFade> FIREWORK_STAR_FADE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkStarFade::category, Recipe.SpecialFireworkStarFade::new);
    public static final NetworkBuffer.Type<Recipe.SpecialTippedArrow> TIPPED_ARROW = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialTippedArrow::category, Recipe.SpecialTippedArrow::new);
    public static final NetworkBuffer.Type<Recipe.SpecialBannerDuplicate> BANNER_DUPLICATE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialBannerDuplicate::category, Recipe.SpecialBannerDuplicate::new);
    public static final NetworkBuffer.Type<Recipe.SpecialShieldDecoration> SHIELD_DECORATION = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialShieldDecoration::category, Recipe.SpecialShieldDecoration::new);
    public static final NetworkBuffer.Type<Recipe.SpecialRepairItem> REPAIR_ITEM = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialRepairItem::category, Recipe.SpecialRepairItem::new);
    public static final NetworkBuffer.Type<Recipe.DecoratedPot> DECORATED_POT = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.DecoratedPot::category, Recipe.DecoratedPot::new);
    public static final NetworkBuffer.Type<Recipe.Transmute> TRANSMUTE = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Transmute::group, NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.Transmute::category, INGREDIENT, Recipe.Transmute::input, INGREDIENT, Recipe.Transmute::material, Material.NETWORK_TYPE, Recipe.Transmute::result, Recipe.Transmute::new);

    public static NetworkBuffer.Type<Recipe.Data> dataSerializer(RecipeType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RecipeType.CRAFTING -> null;
            case RecipeType.SMELTING -> SMELTING;
            case RecipeType.BLASTING -> BLASTING;
            case RecipeType.SMOKING -> SMOKING;
            case RecipeType.CAMPFIRE_COOKING -> CAMPFIRE_COOKING;
            case RecipeType.STONECUTTING -> STONECUTTING;
            case RecipeType.SMITHING -> null;
        };
    }

    public static RecipeType recipeToType(Recipe.Data data) {
        Recipe.Data data2 = data;
        Objects.requireNonNull(data2);
        Recipe.Data data3 = data2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Recipe.Smelting.class, Recipe.Blasting.class, Recipe.Smoking.class, Recipe.CampfireCooking.class, Recipe.Stonecutting.class}, (Object)data3, n)) {
            case 0 -> {
                Recipe.Smelting ignored = (Recipe.Smelting)data3;
                yield RecipeType.SMELTING;
            }
            case 1 -> {
                Recipe.Blasting ignored = (Recipe.Blasting)data3;
                yield RecipeType.BLASTING;
            }
            case 2 -> {
                Recipe.Smoking ignored = (Recipe.Smoking)data3;
                yield RecipeType.SMOKING;
            }
            case 3 -> {
                Recipe.CampfireCooking ignored = (Recipe.CampfireCooking)data3;
                yield RecipeType.CAMPFIRE_COOKING;
            }
            case 4 -> {
                Recipe.Stonecutting ignored = (Recipe.Stonecutting)data3;
                yield RecipeType.STONECUTTING;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(data));
        };
    }
}

