/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.GameMode;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.ItemUpdateStateEvent;
import net.minestom.server.event.player.PlayerCancelDiggingEvent;
import net.minestom.server.event.player.PlayerFinishDiggingEvent;
import net.minestom.server.event.player.PlayerStartDiggingEvent;
import net.minestom.server.event.player.PlayerSwapItemEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.component.BlockPredicates;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.server.play.AcknowledgeBlockChangePacket;
import net.minestom.server.network.packet.server.play.BlockEntityDataPacket;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.block.BlockBreakCalculation;
import net.minestom.server.utils.block.BlockUtils;
import org.jetbrains.annotations.NotNull;

public final class PlayerDiggingListener {
    public static void playerDiggingListener(ClientPlayerDiggingPacket packet, Player player) {
        ClientPlayerDiggingPacket.Status status = packet.status();
        Point blockPosition = packet.blockPosition();
        Instance instance = player.getInstance();
        if (instance == null) {
            return;
        }
        DiggingResult diggingResult = null;
        if (status == ClientPlayerDiggingPacket.Status.STARTED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.startDigging(player, instance, blockPosition, packet.blockFace());
        } else if (status == ClientPlayerDiggingPacket.Status.CANCELLED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.cancelDigging(player, instance, blockPosition);
        } else if (status == ClientPlayerDiggingPacket.Status.FINISHED_DIGGING) {
            if (!instance.isChunkLoaded(blockPosition)) {
                return;
            }
            diggingResult = PlayerDiggingListener.finishDigging(player, instance, blockPosition, packet.blockFace());
        } else if (status == ClientPlayerDiggingPacket.Status.DROP_ITEM_STACK) {
            PlayerDiggingListener.dropStack(player);
        } else if (status == ClientPlayerDiggingPacket.Status.DROP_ITEM) {
            PlayerDiggingListener.dropSingle(player);
        } else if (status == ClientPlayerDiggingPacket.Status.UPDATE_ITEM_STATE) {
            PlayerDiggingListener.updateItemState(player);
        } else if (status == ClientPlayerDiggingPacket.Status.SWAP_ITEM_HAND) {
            PlayerDiggingListener.swapItemHand(player);
        }
        if (diggingResult != null) {
            Registry.BlockEntry registry;
            player.sendPacket(new AcknowledgeBlockChangePacket(packet.sequence()));
            if (!diggingResult.success() && (registry = diggingResult.block().registry()).isBlockEntity()) {
                CompoundBinaryTag data = BlockUtils.extractClientNbt(diggingResult.block());
                player.sendPacketToViewersAndSelf(new BlockEntityDataPacket(blockPosition, registry.blockEntityId(), data));
            }
        }
    }

    private static DiggingResult startDigging(Player player, Instance instance, Point blockPosition, BlockFace blockFace) {
        boolean instantBreak;
        Block block = instance.getBlock(blockPosition);
        if (PlayerDiggingListener.shouldPreventBreaking(player, block)) {
            return new DiggingResult(block, false);
        }
        int breakTicks = BlockBreakCalculation.breakTicks(block, player);
        boolean bl = instantBreak = breakTicks == 0;
        if (!instantBreak) {
            PlayerStartDiggingEvent playerStartDiggingEvent = new PlayerStartDiggingEvent(player, block, new BlockVec(blockPosition), blockFace);
            EventDispatcher.call(playerStartDiggingEvent);
            return new DiggingResult(block, !playerStartDiggingEvent.isCancelled());
        }
        return PlayerDiggingListener.breakBlock(instance, player, blockPosition, block, blockFace);
    }

    private static DiggingResult cancelDigging(Player player, Instance instance, Point blockPosition) {
        Block block = instance.getBlock(blockPosition);
        PlayerCancelDiggingEvent playerCancelDiggingEvent = new PlayerCancelDiggingEvent(player, block, new BlockVec(blockPosition));
        EventDispatcher.call(playerCancelDiggingEvent);
        return new DiggingResult(block, true);
    }

    private static DiggingResult finishDigging(Player player, Instance instance, Point blockPosition, BlockFace blockFace) {
        Block block = instance.getBlock(blockPosition);
        if (PlayerDiggingListener.shouldPreventBreaking(player, block)) {
            return new DiggingResult(block, false);
        }
        int breakTicks = BlockBreakCalculation.breakTicks(block, player);
        if (breakTicks == -1) {
            PlayerCancelDiggingEvent playerCancelDiggingEvent = new PlayerCancelDiggingEvent(player, block, new BlockVec(blockPosition));
            EventDispatcher.call(playerCancelDiggingEvent);
            return new DiggingResult(block, false);
        }
        PlayerFinishDiggingEvent playerFinishDiggingEvent = new PlayerFinishDiggingEvent(player, block, new BlockVec(blockPosition));
        EventDispatcher.call(playerFinishDiggingEvent);
        return PlayerDiggingListener.breakBlock(instance, player, blockPosition, playerFinishDiggingEvent.getBlock(), blockFace);
    }

    private static boolean shouldPreventBreaking(@NotNull Player player, Block block) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return true;
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            ItemStack itemInMainHand = player.getItemInMainHand();
            BlockPredicates breakPredicate = itemInMainHand.get(ItemComponent.CAN_BREAK, BlockPredicates.NEVER);
            return !breakPredicate.test(block);
        }
        return false;
    }

    private static void dropStack(Player player) {
        ItemStack droppedItemStack = player.getItemInMainHand();
        PlayerDiggingListener.dropItem(player, droppedItemStack, ItemStack.AIR);
    }

    private static void dropSingle(Player player) {
        ItemStack handItem = player.getItemInMainHand();
        int handAmount = handItem.amount();
        if (handAmount <= 1) {
            PlayerDiggingListener.dropItem(player, handItem, ItemStack.AIR);
        } else {
            PlayerDiggingListener.dropItem(player, handItem.withAmount(1), handItem.withAmount(handAmount - 1));
        }
    }

    private static void updateItemState(Player player) {
        LivingEntityMeta meta = player.getLivingEntityMeta();
        if (meta == null || !meta.isHandActive()) {
            return;
        }
        PlayerHand hand = meta.getActiveHand();
        ItemUpdateStateEvent itemUpdateStateEvent = player.callItemUpdateStateEvent(hand);
        player.clearItemUse();
        player.triggerStatus((byte)9);
        boolean isOffHand = itemUpdateStateEvent.getHand() == PlayerHand.OFF;
        player.refreshActiveHand(itemUpdateStateEvent.hasHandAnimation(), isOffHand, itemUpdateStateEvent.isRiptideSpinAttack());
    }

    private static void swapItemHand(Player player) {
        ItemStack mainHand = player.getItemInMainHand();
        ItemStack offHand = player.getItemInOffHand();
        PlayerSwapItemEvent swapItemEvent = new PlayerSwapItemEvent(player, offHand, mainHand);
        EventDispatcher.callCancellable(swapItemEvent, () -> {
            player.setItemInMainHand(swapItemEvent.getMainHandItem());
            player.setItemInOffHand(swapItemEvent.getOffHandItem());
        });
    }

    private static DiggingResult breakBlock(Instance instance, Player player, Point blockPosition, Block previousBlock, BlockFace blockFace) {
        Pos playerPosition;
        boolean success = instance.breakBlock(player, blockPosition, blockFace);
        Block updatedBlock = instance.getBlock(blockPosition);
        if (!success && previousBlock.isSolid() && (playerPosition = player.getPosition()).sub(0.0, 1.0, 0.0).samePoint(blockPosition)) {
            player.teleport(playerPosition);
        }
        return new DiggingResult(updatedBlock, success);
    }

    private static void dropItem(@NotNull Player player, @NotNull ItemStack droppedItem, @NotNull ItemStack handItem) {
        if (player.dropItem(droppedItem)) {
            player.setItemInMainHand(handItem);
        } else {
            player.getInventory().update();
        }
    }

    private record DiggingResult(Block block, boolean success) {
    }
}

