/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TrimPatternImpl
extends Record
implements TrimPattern {
    @NotNull
    private final NamespaceID assetId;
    @NotNull
    private final Material template;
    @NotNull
    private final Component description;
    private final boolean isDecal;
    @Nullable
    private final Registry.TrimPatternEntry registry;
    static final BinaryTagSerializer<TrimPattern> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("TrimMaterial is read-only");
    }, trimPattern -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", trimPattern.assetId().asString())).put("template_item", Material.NBT_TYPE.write(trimPattern.template()))).put("description", BinaryTagSerializer.NBT_COMPONENT.write(trimPattern.description()))).putBoolean("decal", trimPattern.isDecal())).build());

    TrimPatternImpl(@NotNull NamespaceID assetId, @NotNull Material template, @NotNull Component description, boolean isDecal, @Nullable Registry.TrimPatternEntry registry) {
        Check.notNull(assetId, "missing asset id");
        Check.notNull(template, "missing template");
        Check.notNull(description, "missing description");
        this.assetId = assetId;
        this.template = template;
        this.description = description;
        this.isDecal = isDecal;
        this.registry = registry;
    }

    TrimPatternImpl(@NotNull Registry.TrimPatternEntry registry) {
        this(registry.assetID(), registry.template(), registry.description(), registry.decal(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TrimPatternImpl.class, "assetId;template;description;isDecal;registry", "assetId", "template", "description", "isDecal", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TrimPatternImpl.class, "assetId;template;description;isDecal;registry", "assetId", "template", "description", "isDecal", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TrimPatternImpl.class, "assetId;template;description;isDecal;registry", "assetId", "template", "description", "isDecal", "registry"}, this, o);
    }

    @Override
    @NotNull
    public NamespaceID assetId() {
        return this.assetId;
    }

    @Override
    @NotNull
    public Material template() {
        return this.template;
    }

    @Override
    @NotNull
    public Component description() {
        return this.description;
    }

    @Override
    public boolean isDecal() {
        return this.isDecal;
    }

    @Override
    @Nullable
    public Registry.TrimPatternEntry registry() {
        return this.registry;
    }
}

