/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import net.kyori.adventure.text.Component;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimPatternImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface TrimPattern
extends ProtocolObject
permits TrimPatternImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<TrimPattern>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::trimPattern);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<TrimPattern>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::trimPattern);

    @NotNull
    public static TrimPattern create(@NotNull NamespaceID assetId, @NotNull Material template, @NotNull Component description, boolean decal) {
        return new TrimPatternImpl(assetId, template, description, decal, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<TrimPattern> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:trim_pattern", TrimPatternImpl.REGISTRY_NBT_TYPE, Registry.Resource.TRIM_PATTERNS, (namespace, props) -> new TrimPatternImpl(Registry.trimPattern(namespace, props)));
    }

    @NotNull
    public NamespaceID assetId();

    @NotNull
    public Material template();

    @NotNull
    public Component description();

    public boolean isDecal();

    @Override
    @Contract(pure=true)
    @Nullable
    public Registry.TrimPatternEntry registry();

    public static final class Builder {
        private NamespaceID assetId;
        private Material template;
        private Component description;
        private boolean decal;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull String assetId) {
            return this.assetId(NamespaceID.from(assetId));
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull NamespaceID assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder template(@NotNull Material template) {
            this.template = template;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder decal(boolean decal) {
            this.decal = decal;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public TrimPattern build() {
            return new TrimPatternImpl(this.assetId, this.template, this.description, this.decal, null);
        }
    }
}

