/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TransactionOption<T> {
    public static final TransactionOption<ItemStack> ALL = (inventory, result, itemChangesMap) -> {
        itemChangesMap.forEach(inventory::setItemStack);
        return result;
    };
    public static final TransactionOption<Boolean> ALL_OR_NOTHING = (inventory, result, itemChangesMap) -> {
        if (result.isAir()) {
            itemChangesMap.forEach(inventory::setItemStack);
            return true;
        }
        return false;
    };
    public static final TransactionOption<Boolean> DRY_RUN = (inventory, result, itemChangesMap) -> result.isAir();

    @NotNull
    public T fill(@NotNull AbstractInventory var1, @NotNull ItemStack var2, @NotNull @NotNull Map<@NotNull Integer, @NotNull ItemStack> var3);

    @NotNull
    default public T fill(@NotNull TransactionType type, @NotNull AbstractInventory inventory, @NotNull ItemStack itemStack) {
        Pair<ItemStack, Map<Integer, ItemStack>> pair = type.process(inventory, itemStack);
        return this.fill(inventory, (ItemStack)pair.left(), (Map)pair.right());
    }
}

