/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.List;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.SetCursorItemPacket;
import net.minestom.server.network.packet.server.play.SetPlayerInventorySlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class PlayerInventory
extends AbstractInventory {
    public static final int INVENTORY_SIZE = 46;
    public static final int INNER_INVENTORY_SIZE = 36;
    private ItemStack cursorItem = ItemStack.AIR;

    public PlayerInventory() {
        super(46);
    }

    @Override
    public synchronized void clear() {
        this.cursorItem = ItemStack.AIR;
        super.clear();
        this.viewers.forEach(viewer -> viewer.sendPacketToViewersAndSelf(viewer.getEquipmentsPacket()));
    }

    @Override
    public int getInnerSize() {
        return 36;
    }

    @Override
    public byte getWindowId() {
        return 0;
    }

    private int getSlotId(@NotNull EquipmentSlot slot, byte heldSlot) {
        return switch (slot) {
            case EquipmentSlot.MAIN_HAND -> heldSlot;
            case EquipmentSlot.OFF_HAND -> 45;
            default -> slot.armorSlot();
        };
    }

    @Nullable
    private EquipmentSlot getEquipmentSlot(int slot, byte heldSlot) {
        return switch (slot) {
            case 45 -> EquipmentSlot.OFF_HAND;
            case 41 -> EquipmentSlot.HELMET;
            case 42 -> EquipmentSlot.CHESTPLATE;
            case 43 -> EquipmentSlot.LEGGINGS;
            case 44 -> EquipmentSlot.BOOTS;
            default -> slot == heldSlot ? EquipmentSlot.MAIN_HAND : null;
        };
    }

    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot slot, byte heldSlot) {
        if (slot == EquipmentSlot.BODY) {
            return ItemStack.AIR;
        }
        return this.getItemStack(this.getSlotId(slot, heldSlot));
    }

    public void setEquipment(@NotNull EquipmentSlot slot, byte heldSlot, @NotNull ItemStack itemStack) {
        if (slot == EquipmentSlot.BODY) {
            Check.fail("PlayerInventory does not support body equipment");
        }
        this.setItemStack(this.getSlotId(slot, heldSlot), itemStack);
    }

    @Override
    public void update(@NotNull Player player) {
        player.sendPacket(this.createWindowItemsPacket());
    }

    @NotNull
    public ItemStack getCursorItem() {
        return this.cursorItem;
    }

    public void setCursorItem(@NotNull ItemStack cursorItem) {
        if (this.cursorItem.equals(cursorItem)) {
            return;
        }
        this.cursorItem = cursorItem;
        this.sendPacketToViewers(new SetCursorItemPacket(cursorItem));
    }

    @Override
    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack item, @NotNull ItemStack previous, boolean sendPacket) {
        for (Player player : this.getViewers()) {
            EquipmentSlot equipmentSlot = this.getEquipmentSlot(slot, player.getHeldSlot());
            if (equipmentSlot == null) continue;
            EntityEquipEvent entityEquipEvent = new EntityEquipEvent(player, item, equipmentSlot);
            EventDispatcher.call(entityEquipEvent);
            item = entityEquipEvent.getEquippedItem();
        }
        super.UNSAFE_itemInsert(slot, item, previous, sendPacket);
    }

    @Override
    public void sendSlotRefresh(int slot, @NotNull ItemStack item, @NotNull ItemStack previous) {
        for (Player player : this.getViewers()) {
            EquipmentSlot equipmentSlot = this.getEquipmentSlot(slot, player.getHeldSlot());
            if (equipmentSlot != null) {
                player.updateEquipmentAttributes(previous, item, equipmentSlot);
                player.syncEquipment(equipmentSlot);
            }
            player.sendPacket(new SetPlayerInventorySlotPacket(slot, item));
        }
    }

    private WindowItemsPacket createWindowItemsPacket() {
        ItemStack[] convertedSlots = new ItemStack[46];
        for (int i = 0; i < this.itemStacks.length; ++i) {
            int slot = PlayerInventoryUtils.convertToPacketSlot(i);
            convertedSlots[slot] = this.itemStacks[i];
        }
        return new WindowItemsPacket(0, 0, List.of(convertedSlots), this.cursorItem);
    }

    @Override
    public boolean leftClick(@NotNull Player player, int slot) {
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.leftClick(player, this, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(@NotNull Player player, int slot) {
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.rightClick(player, this, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean middleClick(@NotNull Player player, int slot) {
        this.update();
        return false;
    }

    @Override
    public boolean drop(@NotNull Player player, boolean all, int slot, int button) {
        ItemStack cursor;
        boolean outsideDrop;
        ItemStack clicked;
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        InventoryClickResult clickResult = this.clickProcessor.drop(player, this, all, convertedSlot, button, clicked = (outsideDrop = slot == -999) ? ItemStack.AIR : this.getItemStack(convertedSlot), cursor = this.getCursorItem());
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (resultClicked != null && !outsideDrop) {
            this.setItemStack(convertedSlot, resultClicked);
        }
        this.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean shiftClick(@NotNull Player player, int slot) {
        int end;
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        boolean hotBarClick = PlayerInventoryUtils.convertSlot(slot, 9) < 9;
        int start = hotBarClick ? 9 : 0;
        InventoryClickResult clickResult = this.clickProcessor.shiftClick(this, this, start, end = hotBarClick ? this.getSize() - 9 : 8, 1, player, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    @Override
    public boolean changeHeld(@NotNull Player player, int slot, int key) {
        int convertedKey = key == 40 ? 45 : key;
        ItemStack cursorItem = this.getCursorItem();
        if (!cursorItem.isAir()) {
            return false;
        }
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        ItemStack heldItem = this.getItemStack(convertedKey);
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(player, this, convertedSlot, convertedKey, clicked, heldItem);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setItemStack(convertedKey, clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.CHANGE_HELD, clicked, cursorItem);
        return true;
    }

    @Override
    public boolean dragging(@NotNull Player player, int slot, int button) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = slot != -999 ? this.getItemStackFromPacketSlot(slot) : ItemStack.AIR;
        InventoryClickResult clickResult = this.clickProcessor.dragging(player, this, PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9), button, clicked, cursor);
        if (clickResult == null || clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    @Override
    public boolean doubleClick(@NotNull Player player, int slot) {
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(this, this, player, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    private void setItemStackFromPacketSlot(int slot, @NotNull ItemStack itemStack) {
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        this.setItemStack(convertedSlot, itemStack);
    }

    private ItemStack getItemStackFromPacketSlot(int slot) {
        int convertedSlot = PlayerInventoryUtils.convertPlayerInventorySlot(slot, 9);
        return this.itemStacks[convertedSlot];
    }
}

