/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.entity.metadata.ObjectDataProvider;
import net.minestom.server.entity.metadata.other.PaintingVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaintingMeta
extends EntityMeta
implements ObjectDataProvider {
    private Orientation orientation = null;

    public PaintingMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public DynamicRegistry.Key<Variant> getVariant() {
        return this.metadata.get(MetadataDef.Painting.VARIANT);
    }

    public void setVariant(@NotNull DynamicRegistry.Key<Variant> value) {
        this.metadata.set(MetadataDef.Painting.VARIANT, value);
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@NotNull Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public int getObjectData() {
        Check.stateCondition(this.orientation == null, "Painting orientation must be set before spawn");
        return this.orientation.id();
    }

    @Override
    public boolean requiresVelocityPacketAtSpawn() {
        return false;
    }

    public static enum Orientation {
        NORTH(2),
        SOUTH(3),
        WEST(4),
        EAST(5);

        private final int id;

        private Orientation(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }

    static final class VariantImpl
    extends Record
    implements Variant {
        @NotNull
        private final NamespaceID assetId;
        private final int width;
        private final int height;
        @Nullable
        private final Registry.PaintingVariantEntry registry;
        private static final BinaryTagSerializer<Variant> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
            throw new UnsupportedOperationException("PaintingVariant is read-only");
        }, variant -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_id", variant.assetId().asString())).putInt("width", variant.width())).putInt("height", variant.height())).build());

        VariantImpl(@NotNull NamespaceID assetId, int width, int height, @Nullable Registry.PaintingVariantEntry registry) {
            Check.argCondition(assetId == null, "missing asset id");
            Check.argCondition(width <= 0, "width must be positive");
            Check.argCondition(height <= 0, "height must be positive");
            this.assetId = assetId;
            this.width = width;
            this.height = height;
            this.registry = registry;
        }

        VariantImpl(@NotNull Registry.PaintingVariantEntry registry) {
            this(registry.assetId(), registry.width(), registry.height(), registry);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{VariantImpl.class, "assetId;width;height;registry", "assetId", "width", "height", "registry"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VariantImpl.class, "assetId;width;height;registry", "assetId", "width", "height", "registry"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VariantImpl.class, "assetId;width;height;registry", "assetId", "width", "height", "registry"}, this, o);
        }

        @Override
        @NotNull
        public NamespaceID assetId() {
            return this.assetId;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int height() {
            return this.height;
        }

        @Override
        @Nullable
        public Registry.PaintingVariantEntry registry() {
            return this.registry;
        }
    }

    public static sealed interface Variant
    extends ProtocolObject,
    PaintingVariants
    permits VariantImpl {
        @NotNull
        public static final NetworkBuffer.Type<DynamicRegistry.Key<Variant>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::paintingVariant);
        @NotNull
        public static final BinaryTagSerializer<DynamicRegistry.Key<Variant>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::paintingVariant);

        @NotNull
        public static Variant create(@NotNull NamespaceID assetId, int width, int height) {
            return new VariantImpl(assetId, width, height, null);
        }

        @NotNull
        public static Builder builder() {
            return new Builder();
        }

        @ApiStatus.Internal
        @NotNull
        public static DynamicRegistry<Variant> createDefaultRegistry() {
            return DynamicRegistry.create("minecraft:painting_variant", VariantImpl.REGISTRY_NBT_TYPE, Registry.Resource.PAINTING_VARIANTS, (namespace, props) -> new VariantImpl(Registry.paintingVariant(namespace, props)));
        }

        @NotNull
        public NamespaceID assetId();

        public int width();

        public int height();

        @Override
        @Nullable
        public Registry.PaintingVariantEntry registry();

        public static class Builder {
            private NamespaceID assetId;
            private int width;
            private int height;

            private Builder() {
            }

            @Contract(value="_ -> this", pure=true)
            @NotNull
            public Builder assetId(@NotNull NamespaceID assetId) {
                this.assetId = assetId;
                return this;
            }

            @Contract(value="_ -> this", pure=true)
            @NotNull
            public Builder width(int width) {
                this.width = width;
                return this;
            }

            @Contract(value="_ -> this", pure=true)
            @NotNull
            public Builder height(int height) {
                this.height = height;
                return this;
            }

            @NotNull
            public Variant build() {
                return new VariantImpl(this.assetId, this.width, this.height, null);
            }
        }
    }
}

