/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.display;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.EntityMeta;
import org.jetbrains.annotations.NotNull;

public class AbstractDisplayMeta
extends EntityMeta {
    protected AbstractDisplayMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public int getTransformationInterpolationStartDelta() {
        return this.metadata.get(MetadataDef.Display.INTERPOLATION_DELAY);
    }

    public void setTransformationInterpolationStartDelta(int value) {
        this.metadata.set(MetadataDef.Display.INTERPOLATION_DELAY, value);
    }

    public int getTransformationInterpolationDuration() {
        return this.metadata.get(MetadataDef.Display.TRANSFORMATION_INTERPOLATION_DURATION);
    }

    public void setTransformationInterpolationDuration(int value) {
        this.metadata.set(MetadataDef.Display.TRANSFORMATION_INTERPOLATION_DURATION, value);
    }

    public int getPosRotInterpolationDuration() {
        return this.metadata.get(MetadataDef.Display.POSITION_ROTATION_INTERPOLATION_DURATION);
    }

    public void setPosRotInterpolationDuration(int value) {
        this.metadata.set(MetadataDef.Display.POSITION_ROTATION_INTERPOLATION_DURATION, value);
    }

    @NotNull
    public Point getTranslation() {
        return this.metadata.get(MetadataDef.Display.TRANSLATION);
    }

    public void setTranslation(@NotNull Point value) {
        this.metadata.set(MetadataDef.Display.TRANSLATION, value);
    }

    @NotNull
    public Vec getScale() {
        return Vec.fromPoint(this.metadata.get(MetadataDef.Display.SCALE));
    }

    public void setScale(@NotNull Vec value) {
        this.metadata.set(MetadataDef.Display.SCALE, value);
    }

    public float @NotNull [] getLeftRotation() {
        return this.metadata.get(MetadataDef.Display.ROTATION_LEFT);
    }

    public void setLeftRotation(float @NotNull [] value) {
        this.metadata.set(MetadataDef.Display.ROTATION_LEFT, value);
    }

    public float @NotNull [] getRightRotation() {
        return this.metadata.get(MetadataDef.Display.ROTATION_RIGHT);
    }

    public void setRightRotation(float @NotNull [] value) {
        this.metadata.set(MetadataDef.Display.ROTATION_RIGHT, value);
    }

    @NotNull
    public BillboardConstraints getBillboardRenderConstraints() {
        return BillboardConstraints.VALUES[this.metadata.get(MetadataDef.Display.BILLBOARD_CONSTRAINTS)];
    }

    public void setBillboardRenderConstraints(@NotNull BillboardConstraints value) {
        this.metadata.set(MetadataDef.Display.BILLBOARD_CONSTRAINTS, (byte)value.ordinal());
    }

    public int getBrightnessOverride() {
        return this.metadata.get(MetadataDef.Display.BRIGHTNESS_OVERRIDE);
    }

    public void setBrightnessOverride(int value) {
        this.metadata.set(MetadataDef.Display.BRIGHTNESS_OVERRIDE, value);
    }

    public float getViewRange() {
        return this.metadata.get(MetadataDef.Display.VIEW_RANGE).floatValue();
    }

    public void setViewRange(float value) {
        this.metadata.set(MetadataDef.Display.VIEW_RANGE, Float.valueOf(value));
    }

    public float getShadowRadius() {
        return this.metadata.get(MetadataDef.Display.SHADOW_RADIUS).floatValue();
    }

    public void setShadowRadius(float value) {
        this.metadata.set(MetadataDef.Display.SHADOW_RADIUS, Float.valueOf(value));
    }

    public float getShadowStrength() {
        return this.metadata.get(MetadataDef.Display.SHADOW_STRENGTH).floatValue();
    }

    public void setShadowStrength(float value) {
        this.metadata.set(MetadataDef.Display.SHADOW_STRENGTH, Float.valueOf(value));
    }

    public float getWidth() {
        return this.metadata.get(MetadataDef.Display.WIDTH).floatValue();
    }

    public void setWidth(float value) {
        this.metadata.set(MetadataDef.Display.WIDTH, Float.valueOf(value));
    }

    public float getHeight() {
        return this.metadata.get(MetadataDef.Display.HEIGHT).floatValue();
    }

    public void setHeight(float value) {
        this.metadata.set(MetadataDef.Display.HEIGHT, Float.valueOf(value));
    }

    public int getGlowColorOverride() {
        return this.metadata.get(MetadataDef.Display.GLOW_COLOR_OVERRIDE);
    }

    public void setGlowColorOverride(int value) {
        this.metadata.set(MetadataDef.Display.GLOW_COLOR_OVERRIDE, value);
    }

    public static enum BillboardConstraints {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

        private static final BillboardConstraints[] VALUES;

        static {
            VALUES = BillboardConstraints.values();
        }
    }
}

