/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public enum EquipmentSlot {
    MAIN_HAND(false, -1, "mainhand"),
    OFF_HAND(false, -1, "offhand"),
    BOOTS(true, 44, "feet"),
    LEGGINGS(true, 43, "legs"),
    CHESTPLATE(true, 42, "chest"),
    HELMET(true, 41, "head"),
    BODY(false, -1, "body");

    private static final List<EquipmentSlot> ARMORS;
    private static final Map<String, EquipmentSlot> BY_NBT_NAME;
    public static final NetworkBuffer.Type<EquipmentSlot> NETWORK_TYPE;
    public static final BinaryTagSerializer<EquipmentSlot> NBT_TYPE;
    private final boolean armor;
    private final int armorSlot;
    private final String nbtName;

    private EquipmentSlot(boolean armor, int armorSlot, String nbtName) {
        this.armor = armor;
        this.armorSlot = armorSlot;
        this.nbtName = nbtName;
    }

    public boolean isHand() {
        return this == MAIN_HAND || this == OFF_HAND;
    }

    public boolean isArmor() {
        return this.armor;
    }

    public int armorSlot() {
        return this.armorSlot;
    }

    @NotNull
    public String nbtName() {
        return this.nbtName;
    }

    @NotNull
    public static @NotNull List<@NotNull EquipmentSlot> armors() {
        return ARMORS;
    }

    static {
        ARMORS = List.of(BOOTS, LEGGINGS, CHESTPLATE, HELMET);
        BY_NBT_NAME = Arrays.stream(EquipmentSlot.values()).collect(Collectors.toMap(EquipmentSlot::nbtName, slot -> slot));
        NETWORK_TYPE = NetworkBuffer.Enum(EquipmentSlot.class);
        NBT_TYPE = BinaryTagSerializer.STRING.map(BY_NBT_NAME::get, EquipmentSlot::nbtName);
    }
}

