/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientPlayerPositionPacket(@NotNull Point position, byte flags) implements ClientPacket
{
    public static final int FLAG_ON_GROUND = 1;
    public static final int FLAG_HORIZONTAL_COLLISION = 2;
    public static final NetworkBuffer.Type<ClientPlayerPositionPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VECTOR3D, ClientPlayerPositionPacket::position, NetworkBuffer.BYTE, ClientPlayerPositionPacket::flags, ClientPlayerPositionPacket::new);

    public ClientPlayerPositionPacket(@NotNull Point position, boolean onGround, boolean horizontalCollision) {
        this(position, (byte)((onGround ? (byte)1 : 0) | (byte)(horizontalCollision ? 2 : 0)));
    }

    public boolean onGround() {
        return (this.flags & 1) != 0;
    }

    public boolean horizontalCollision() {
        return (this.flags & 2) != 0;
    }
}

