/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle.data;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.Particle;
import net.minestom.server.particle.data.BlockMarkerParticleData;
import net.minestom.server.particle.data.BlockParticleData;
import net.minestom.server.particle.data.DustColorTransitionParticleData;
import net.minestom.server.particle.data.DustParticleData;
import net.minestom.server.particle.data.FallingDustParticleData;
import net.minestom.server.particle.data.ItemParticleData;
import net.minestom.server.particle.data.SculkChargeParticleData;
import net.minestom.server.particle.data.ShriekParticleData;
import net.minestom.server.particle.data.VibrationParticleData;
import org.jetbrains.annotations.NotNull;

public interface ParticleData {
    public void write(@NotNull NetworkBuffer var1);

    public static ParticleData read(int particleId, NetworkBuffer reader) {
        if (particleId == Particle.BLOCK.id()) {
            return new BlockParticleData(reader);
        }
        if (particleId == Particle.BLOCK_MARKER.id()) {
            return new BlockMarkerParticleData(reader);
        }
        if (particleId == Particle.DUST.id()) {
            return new DustParticleData(reader);
        }
        if (particleId == Particle.DUST_COLOR_TRANSITION.id()) {
            return new DustColorTransitionParticleData(reader);
        }
        if (particleId == Particle.FALLING_DUST.id()) {
            return new FallingDustParticleData(reader);
        }
        if (particleId == Particle.SCULK_CHARGE.id()) {
            return new SculkChargeParticleData(reader);
        }
        if (particleId == Particle.ITEM.id()) {
            return new ItemParticleData(reader);
        }
        if (particleId == Particle.VIBRATION.id()) {
            return new VibrationParticleData(reader);
        }
        if (particleId == Particle.SHRIEK.id()) {
            return new ShriekParticleData(reader);
        }
        return null;
    }

    public boolean validate(int var1);

    public static boolean requiresData(int particleId) {
        return particleId == Particle.BLOCK.id() || particleId == Particle.BLOCK_MARKER.id() || particleId == Particle.DUST.id() || particleId == Particle.DUST_COLOR_TRANSITION.id() || particleId == Particle.FALLING_DUST.id() || particleId == Particle.SCULK_CHARGE.id() || particleId == Particle.ITEM.id() || particleId == Particle.VIBRATION.id() || particleId == Particle.SHRIEK.id();
    }

    public static ParticleData defaultData(String id) {
        return switch (id) {
            case "minecraft:block" -> new BlockParticleData();
            case "minecraft:block_marker" -> new BlockMarkerParticleData();
            case "minecraft:dust" -> new DustParticleData();
            case "minecraft:dust_color_transition" -> new DustColorTransitionParticleData();
            case "minecraft:falling_dust" -> new FallingDustParticleData();
            case "minecraft:sculk_charge" -> new SculkChargeParticleData();
            case "minecraft:item" -> new ItemParticleData();
            case "minecraft:vibration" -> new VibrationParticleData();
            case "minecraft:shriek" -> new ShriekParticleData();
            default -> null;
        };
    }
}

