/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.List;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.recipe.RecipeCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DeclareRecipesPacket(@NotNull List<DeclaredRecipe> recipes) implements ServerPacket.Play
{
    public static final int MAX_RECIPES = Short.MAX_VALUE;
    public static final int MAX_INGREDIENTS = 128;

    public DeclareRecipesPacket(@NotNull List<DeclaredRecipe> recipes) {
        recipes = List.copyOf(recipes);
    }

    public DeclareRecipesPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(r -> {
            String type;
            return switch (type = r.read(NetworkBuffer.STRING)) {
                case "crafting_shapeless" -> new DeclaredShapelessCraftingRecipe(reader);
                case "crafting_shaped" -> new DeclaredShapedCraftingRecipe(reader);
                case "smelting" -> new DeclaredSmeltingRecipe(reader);
                case "blasting" -> new DeclaredBlastingRecipe(reader);
                case "smoking" -> new DeclaredSmokingRecipe(reader);
                case "campfire_cooking" -> new DeclaredCampfireCookingRecipe(reader);
                case "stonecutting" -> new DeclaredStonecutterRecipe(reader);
                case "smithing_trim" -> new DeclaredSmithingTrimRecipe(reader);
                case "smithing_transform" -> new DeclaredSmithingTransformRecipe(reader);
                default -> throw new UnsupportedOperationException("Unrecognized type: " + type);
            };
        }, Short.MAX_VALUE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.recipes, (bWriter, recipe) -> {
            bWriter.write(NetworkBuffer.STRING, recipe.type());
            bWriter.write(NetworkBuffer.STRING, recipe.recipeId());
            bWriter.write((NetworkBuffer.Writer)recipe);
        });
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.DECLARE_RECIPES;
    }

    public static sealed interface DeclaredRecipe
    extends NetworkBuffer.Writer
    permits DeclaredShapelessCraftingRecipe, DeclaredShapedCraftingRecipe, DeclaredSmeltingRecipe, DeclaredBlastingRecipe, DeclaredSmokingRecipe, DeclaredCampfireCookingRecipe, DeclaredStonecutterRecipe, DeclaredSmithingTrimRecipe, DeclaredSmithingTransformRecipe {
        @NotNull
        public String type();

        @NotNull
        public String recipeId();
    }

    public record DeclaredShapelessCraftingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Crafting crafting, @NotNull List<Ingredient> ingredients, @NotNull ItemStack result) implements DeclaredRecipe
    {
        private DeclaredShapelessCraftingRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Crafting.class), reader.readCollection(Ingredient::new, 128), reader.read(NetworkBuffer.ITEM));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Crafting.class, this.crafting);
            writer.writeCollection(this.ingredients);
            writer.write(NetworkBuffer.ITEM, this.result);
        }

        @Override
        @NotNull
        public String type() {
            return "crafting_shapeless";
        }
    }

    public record DeclaredShapedCraftingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Crafting category, int width, int height, @NotNull List<Ingredient> ingredients, @NotNull ItemStack result, boolean showNotification) implements DeclaredRecipe
    {
        public DeclaredShapedCraftingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Crafting category, int width, int height, @NotNull List<Ingredient> ingredients, @NotNull ItemStack result, boolean showNotification) {
            ingredients = List.copyOf(ingredients);
        }

        private DeclaredShapedCraftingRecipe(DeclaredShapedCraftingRecipe packet) {
            this(packet.recipeId, packet.group, packet.category, packet.width, packet.height, packet.ingredients, packet.result, packet.showNotification);
        }

        public DeclaredShapedCraftingRecipe(@NotNull NetworkBuffer reader) {
            this(DeclaredShapedCraftingRecipe.read(reader));
        }

        private static DeclaredShapedCraftingRecipe read(@NotNull NetworkBuffer reader) {
            String recipeId = reader.read(NetworkBuffer.STRING);
            String group = reader.read(NetworkBuffer.STRING);
            RecipeCategory.Crafting category = reader.readEnum(RecipeCategory.Crafting.class);
            int width = reader.read(NetworkBuffer.VAR_INT);
            int height = reader.read(NetworkBuffer.VAR_INT);
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int slot = 0; slot < width * height; ++slot) {
                ingredients.add(new Ingredient(reader));
            }
            ItemStack result = reader.read(NetworkBuffer.ITEM);
            boolean showNotification = reader.read(NetworkBuffer.BOOLEAN);
            return new DeclaredShapedCraftingRecipe(recipeId, group, category, width, height, ingredients, result, showNotification);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Crafting.class, this.category);
            writer.write(NetworkBuffer.VAR_INT, this.width);
            writer.write(NetworkBuffer.VAR_INT, this.height);
            for (Ingredient ingredient : this.ingredients) {
                ingredient.write(writer);
            }
            writer.write(NetworkBuffer.ITEM, this.result);
            writer.write(NetworkBuffer.BOOLEAN, this.showNotification);
        }

        @Override
        @NotNull
        public String type() {
            return "crafting_shaped";
        }
    }

    public record DeclaredSmeltingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Cooking category, @NotNull Ingredient ingredient, @NotNull ItemStack result, float experience, int cookingTime) implements DeclaredRecipe
    {
        public DeclaredSmeltingRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(NetworkBuffer.ITEM), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(NetworkBuffer.ITEM, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public String type() {
            return "smelting";
        }
    }

    public record DeclaredBlastingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Cooking category, @NotNull Ingredient ingredient, @NotNull ItemStack result, float experience, int cookingTime) implements DeclaredRecipe
    {
        public DeclaredBlastingRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(NetworkBuffer.ITEM), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(NetworkBuffer.ITEM, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public String type() {
            return "blasting";
        }
    }

    public record DeclaredSmokingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Cooking category, @NotNull Ingredient ingredient, @NotNull ItemStack result, float experience, int cookingTime) implements DeclaredRecipe
    {
        public DeclaredSmokingRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(NetworkBuffer.ITEM), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(NetworkBuffer.ITEM, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public String type() {
            return "smoking";
        }
    }

    public record DeclaredCampfireCookingRecipe(@NotNull String recipeId, @NotNull String group, @NotNull RecipeCategory.Cooking category, @NotNull Ingredient ingredient, @NotNull ItemStack result, float experience, int cookingTime) implements DeclaredRecipe
    {
        public DeclaredCampfireCookingRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(NetworkBuffer.ITEM), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(NetworkBuffer.ITEM, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public String type() {
            return "campfire_cooking";
        }
    }

    public record DeclaredStonecutterRecipe(String recipeId, String group, Ingredient ingredient, ItemStack result) implements DeclaredRecipe
    {
        public DeclaredStonecutterRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), new Ingredient(reader), reader.read(NetworkBuffer.ITEM));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.write(this.ingredient);
            writer.write(NetworkBuffer.ITEM, this.result);
        }

        @Override
        @NotNull
        public String type() {
            return "stonecutting";
        }
    }

    public record DeclaredSmithingTrimRecipe(String recipeId, Ingredient template, Ingredient base, Ingredient addition) implements DeclaredRecipe
    {
        public DeclaredSmithingTrimRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), new Ingredient(reader), new Ingredient(reader), new Ingredient(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(this.template);
            writer.write(this.base);
            writer.write(this.addition);
        }

        @Override
        @NotNull
        public String type() {
            return "smithing_trim";
        }
    }

    public record DeclaredSmithingTransformRecipe(String recipeId, Ingredient template, Ingredient base, Ingredient addition, ItemStack result) implements DeclaredRecipe
    {
        public DeclaredSmithingTransformRecipe(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), new Ingredient(reader), new Ingredient(reader), new Ingredient(reader), reader.read(NetworkBuffer.ITEM));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(this.template);
            writer.write(this.base);
            writer.write(this.addition);
            writer.write(NetworkBuffer.ITEM, this.result);
        }

        @Override
        @NotNull
        public String type() {
            return "smithing_transform";
        }
    }

    public record Ingredient(@Nullable List<ItemStack> items) implements NetworkBuffer.Writer
    {
        public Ingredient(@Nullable List<ItemStack> items) {
            items = items == null ? null : List.copyOf(items);
        }

        public Ingredient(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(NetworkBuffer.ITEM, 128));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(NetworkBuffer.ITEM, this.items);
        }
    }
}

