/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.preplay;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.network.plugin.LoginPluginResponse;
import net.minestom.server.utils.async.AsyncUtils;
import org.jetbrains.annotations.NotNull;

public final class LoginListener {
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();
    private static final Gson GSON = new Gson();
    private static final Component ALREADY_CONNECTED = Component.text((String)"You are already on this server", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_DURING_LOGIN = Component.text((String)"Error during login!", (TextColor)NamedTextColor.RED);
    public static final Component INVALID_PROXY_RESPONSE = Component.text((String)"Invalid proxy response!", (TextColor)NamedTextColor.RED);

    public static void loginStartListener(@NotNull ClientLoginStartPacket packet, @NotNull PlayerConnection connection) {
        PlayerSocketConnection socketConnection;
        boolean isSocketConnection = connection instanceof PlayerSocketConnection;
        if (isSocketConnection) {
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.UNSAFE_setLoginUsername(packet.username());
            if (VelocityProxy.isEnabled()) {
                connection.loginPluginMessageProcessor().request("velocity:player_info", null).thenAccept(response -> LoginListener.handleVelocityProxyResponse(socketConnection, response));
                return;
            }
        }
        if (MojangAuth.isEnabled() && isSocketConnection) {
            if (CONNECTION_MANAGER.getOnlinePlayerByUsername(packet.username()) != null) {
                connection.sendPacket(new LoginDisconnectPacket(ALREADY_CONNECTED));
                connection.disconnect();
                return;
            }
            socketConnection = (PlayerSocketConnection)connection;
            byte[] publicKey = MojangAuth.getKeyPair().getPublic().getEncoded();
            byte[] nonce = new byte[4];
            ThreadLocalRandom.current().nextBytes(nonce);
            socketConnection.setNonce(nonce);
            socketConnection.sendPacket(new EncryptionRequestPacket("", publicKey, nonce));
        } else {
            boolean bungee = BungeeCordProxy.isEnabled();
            UUID playerUuid = bungee && isSocketConnection ? ((PlayerSocketConnection)connection).gameProfile().uuid() : CONNECTION_MANAGER.getPlayerConnectionUuid(connection, packet.username());
            CONNECTION_MANAGER.createPlayer(connection, playerUuid, packet.username());
        }
    }

    public static void loginEncryptionResponseListener(@NotNull ClientEncryptionResponsePacket packet, @NotNull PlayerConnection connection) {
        if (!(connection instanceof PlayerSocketConnection)) {
            return;
        }
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        AsyncUtils.runAsync(() -> {
            boolean verificationFailed;
            String loginUsername = socketConnection.getLoginUsername();
            if (loginUsername == null || loginUsername.isEmpty()) {
                return;
            }
            boolean hasPublicKey = connection.playerPublicKey() != null;
            boolean bl = verificationFailed = hasPublicKey || !Arrays.equals(socketConnection.getNonce(), MojangCrypt.decryptUsingKey(MojangAuth.getKeyPair().getPrivate(), packet.encryptedVerifyToken()));
            if (verificationFailed) {
                MinecraftServer.LOGGER.error("Encryption failed for {}", (Object)loginUsername);
                return;
            }
            byte[] digestedData = MojangCrypt.digestData("", MojangAuth.getKeyPair().getPublic(), LoginListener.getSecretKey(packet.sharedSecret()));
            if (digestedData == null) {
                MinecraftServer.LOGGER.error("Connection {} failed initializing encryption.", (Object)socketConnection.getRemoteAddress());
                connection.disconnect();
                return;
            }
            String serverId = new BigInteger(digestedData).toString(16);
            String username = URLEncoder.encode(loginUsername, StandardCharsets.UTF_8);
            String url = String.format(MojangAuth.AUTH_URL, username, serverId);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(url)).GET().build();
            client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).whenComplete((response, throwable) -> {
                boolean ok;
                boolean bl = ok = throwable == null && response.statusCode() == 200 && response.body() != null && !((String)response.body()).isEmpty();
                if (!ok) {
                    if (throwable != null) {
                        MinecraftServer.getExceptionManager().handleException((Throwable)throwable);
                    }
                    if (socketConnection.getPlayer() != null) {
                        socketConnection.getPlayer().kick((Component)Component.text((String)"Failed to contact Mojang's Session Servers (Are they down?)"));
                    } else {
                        socketConnection.disconnect();
                    }
                    return;
                }
                try {
                    JsonObject gameProfile = (JsonObject)GSON.fromJson((String)response.body(), JsonObject.class);
                    socketConnection.setEncryptionKey(LoginListener.getSecretKey(packet.sharedSecret()));
                    UUID profileUUID = UUID.fromString(gameProfile.get("id").getAsString().replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                    String profileName = gameProfile.get("name").getAsString();
                    MinecraftServer.LOGGER.info("UUID of player {} is {}", (Object)loginUsername, (Object)profileUUID);
                    CONNECTION_MANAGER.createPlayer(connection, profileUUID, profileName);
                    ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
                    for (JsonElement element : gameProfile.get("properties").getAsJsonArray()) {
                        JsonObject object = element.getAsJsonObject();
                        propertyList.add(new GameProfile.Property(object.get("name").getAsString(), object.get("value").getAsString(), object.get("signature").getAsString()));
                    }
                    socketConnection.UNSAFE_setProfile(new GameProfile(profileUUID, profileName, propertyList));
                }
                catch (Exception e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            });
        });
    }

    private static SecretKey getSecretKey(byte[] sharedSecret) {
        return MojangCrypt.decryptByteToSecretKey(MojangAuth.getKeyPair().getPrivate(), sharedSecret);
    }

    private static void handleVelocityProxyResponse(PlayerSocketConnection socketConnection, LoginPluginResponse response) {
        NetworkBuffer buffer;
        byte[] data = response.getPayload();
        InetSocketAddress socketAddress = null;
        GameProfile gameProfile = null;
        boolean success = false;
        if (data != null && data.length > 0 && (success = VelocityProxy.checkIntegrity(buffer = new NetworkBuffer(ByteBuffer.wrap(data))))) {
            InetAddress address;
            try {
                address = InetAddress.getByName(buffer.read(NetworkBuffer.STRING));
            }
            catch (UnknownHostException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                return;
            }
            int port = ((InetSocketAddress)socketConnection.getRemoteAddress()).getPort();
            socketAddress = new InetSocketAddress(address, port);
            gameProfile = new GameProfile(buffer);
        }
        if (success) {
            socketConnection.setRemoteAddress(socketAddress);
            socketConnection.UNSAFE_setProfile(gameProfile);
            CONNECTION_MANAGER.createPlayer(socketConnection, gameProfile.uuid(), gameProfile.name());
        } else {
            LoginDisconnectPacket disconnectPacket = new LoginDisconnectPacket(INVALID_PROXY_RESPONSE);
            socketConnection.sendPacket(disconnectPacket);
        }
    }

    public static void loginPluginResponseListener(@NotNull ClientLoginPluginResponsePacket packet, @NotNull PlayerConnection connection) {
        try {
            LoginPluginMessageProcessor messageProcessor = connection.loginPluginMessageProcessor();
            messageProcessor.handleResponse(packet.messageId(), packet.data());
        }
        catch (Throwable t) {
            MinecraftServer.LOGGER.error("Error handling Login Plugin Response", t);
            LoginDisconnectPacket disconnectPacket = new LoginDisconnectPacket(ERROR_DURING_LOGIN);
            connection.sendPacket(disconnectPacket);
            connection.disconnect();
        }
    }

    public static void loginAckListener(@NotNull ClientLoginAcknowledgedPacket ignored, @NotNull PlayerConnection connection) {
        Player player = Objects.requireNonNull(connection.getPlayer());
        CONNECTION_MANAGER.doConfiguration(player, true);
    }
}

