/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jetbrains.annotations.Blocking;

public final class URLUtils {
    private URLUtils() {
    }

    @Blocking
    public static String getText(String url) throws IOException {
        String currentLine;
        InputStream inputStream = URLUtils.getInputStream(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder response = new StringBuilder();
        while ((currentLine = in.readLine()) != null) {
            response.append(currentLine);
        }
        in.close();
        return response.toString();
    }

    private static InputStream getInputStream(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        int responseCode = connection.getResponseCode();
        InputStream inputStream = 200 <= responseCode && responseCode <= 299 ? connection.getInputStream() : connection.getErrorStream();
        return inputStream;
    }
}

