/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import org.jetbrains.annotations.NotNull;

public sealed interface Range<T extends Number> {
    public boolean isInRange(@NotNull T var1);

    public record Double(double minimum, double maximum) implements Range<java.lang.Double>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Double value) {
            return value >= this.minimum && value <= this.maximum;
        }
    }

    public record Float(float minimum, float maximum) implements Range<java.lang.Float>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Float value) {
            return value.floatValue() >= this.minimum && value.floatValue() <= this.maximum;
        }
    }

    public record Long(long minimum, long maximum) implements Range<java.lang.Long>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Long value) {
            return value >= this.minimum && value <= this.maximum;
        }
    }

    public record Integer(int minimum, int maximum) implements Range<java.lang.Integer>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Integer value) {
            return value >= this.minimum && value <= this.maximum;
        }
    }

    public record Short(short minimum, short maximum) implements Range<java.lang.Short>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Short value) {
            return value >= this.minimum && value <= this.maximum;
        }
    }

    public record Byte(byte minimum, byte maximum) implements Range<java.lang.Byte>
    {
        @Override
        public boolean isInRange(@NotNull java.lang.Byte value) {
            return value >= this.minimum && value <= this.maximum;
        }
    }
}

