/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minestom.server.utils.MojangUtils;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlayerSkin(String textures, String signature) {
    @Blocking
    @Nullable
    public static PlayerSkin fromUuid(@NotNull String uuid) {
        JsonObject jsonObject = MojangUtils.fromUuid(uuid);
        if (jsonObject == null) {
            return null;
        }
        try {
            JsonArray propertiesArray = jsonObject.get("properties").getAsJsonArray();
            for (JsonElement jsonElement : propertiesArray) {
                JsonObject propertyObject = jsonElement.getAsJsonObject();
                String name = propertyObject.get("name").getAsString();
                if (!name.equals("textures")) continue;
                String textureValue = propertyObject.get("value").getAsString();
                String signatureValue = propertyObject.get("signature").getAsString();
                return new PlayerSkin(textureValue, signatureValue);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Blocking
    @Nullable
    public static PlayerSkin fromUsername(@NotNull String username) {
        JsonObject jsonObject = MojangUtils.fromUsername(username);
        if (jsonObject == null) {
            return null;
        }
        try {
            String uuid = jsonObject.get("id").getAsString();
            return PlayerSkin.fromUuid(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public String getTextures() {
        return this.textures;
    }

    @Deprecated
    public String getSignature() {
        return this.signature;
    }
}

