/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import org.jetbrains.annotations.NotNull;

public final class CoordConversionUtils {
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Z = 16;

    public static int globalToChunk(double xz) {
        return CoordConversionUtils.globalToChunk((int)Math.floor(xz));
    }

    public static int globalToChunk(int xz) {
        return xz >> 4;
    }

    public static int globalToSection(int xyz) {
        return xyz & 0xF;
    }

    public static long chunkIndex(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static long chunkIndex(@NotNull Point point) {
        return CoordConversionUtils.chunkIndex(point.chunkX(), point.chunkZ());
    }

    public static int chunkIndexToChunkX(long index) {
        return (int)(index >> 32);
    }

    public static int chunkIndexToChunkZ(long index) {
        return (int)index;
    }

    public static int blockIndex(int x, int y, int z) {
        z %= 16;
        int index = (x %= 16) & 0xF;
        if (y > 0) {
            index |= y << 4 & 0x7FFFFF0;
        } else {
            index |= -y << 4 & 0x7FFFFF0;
            index |= 0x8000000;
        }
        return index |= z << 28 & 0xF0000000;
    }

    public static int blockIndexToChunkPositionX(int index) {
        return index & 0xF;
    }

    public static int blockIndexToChunkPositionY(int index) {
        int y = (index & 0x7FFFFF0) >>> 4;
        if ((index >>> 27 & 1) == 1) {
            y = -y;
        }
        return y;
    }

    public static int blockIndexToChunkPositionZ(int index) {
        return index >> 28 & 0xF;
    }

    @NotNull
    public static Point blockIndexToGlobal(int index, int chunkX, int chunkZ) {
        int x = CoordConversionUtils.blockIndexToChunkPositionX(index) + 16 * chunkX;
        int y = CoordConversionUtils.blockIndexToChunkPositionY(index);
        int z = CoordConversionUtils.blockIndexToChunkPositionZ(index) + 16 * chunkZ;
        return new Vec(x, y, z);
    }

    public static int globalToSectionRelative(int xyz) {
        return xyz & 0xF;
    }

    public static int chunkToRegion(int chunkCoordinate) {
        return chunkCoordinate >> 5;
    }

    public static int chunkToRegionLocal(int chunkCoordinate) {
        return chunkCoordinate & 0x1F;
    }

    public static int floorSection(int coordinate) {
        return coordinate - (coordinate & 0xF);
    }

    public static int ceilSection(int coordinate) {
        return (coordinate - 1 | 0xF) + 1;
    }
}

