/*
 * Decompiled with CFR 0.152.
 */
package net.micwin.ticino.entities.wiring;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.micwin.ticino.entities.wiring.Wiring;

public class WiringBuilder {
    private Map<Class<?>, Object> fMap = new HashMap();

    public WiringBuilder add(Object pSilbling) {
        this.fMap.put(pSilbling.getClass(), pSilbling);
        return this;
    }

    public Wiring wire() {
        for (Object lObject : this.fMap.values()) {
            this.pWire(lObject, lObject.getClass());
        }
        return new Wiring(this.fMap);
    }

    private void pWire(Object pObject, Class<? extends Object> pClassLevel) {
        Field[] lFields;
        if (pClassLevel == Object.class || pClassLevel.isInterface() || pClassLevel.isPrimitive()) {
            return;
        }
        for (Field lField : lFields = pClassLevel.getDeclaredFields()) {
            Object lCandidate;
            int lModifiers = lField.getModifiers();
            if (Modifier.isNative(lModifiers) || Modifier.isAbstract(lModifiers) || Modifier.isFinal(lModifiers)) continue;
            Class<Object> lFieldType = lField.getType();
            if (lFieldType.isPrimitive()) {
                if (lFieldType == Integer.TYPE) {
                    lFieldType = Integer.class;
                } else if (lFieldType == Double.TYPE) {
                    lFieldType = Double.class;
                } else if (lFieldType == Boolean.TYPE) {
                    lFieldType = Boolean.class;
                } else if (lFieldType == Long.TYPE) {
                    lFieldType = Long.class;
                } else if (lFieldType == Float.TYPE) {
                    lFieldType = Float.class;
                } else if (lFieldType == Character.TYPE) {
                    lFieldType = Character.class;
                } else if (lFieldType == Byte.TYPE) {
                    lFieldType = Byte.class;
                } else if (lFieldType == Short.TYPE) {
                    lFieldType = Short.class;
                }
            }
            if ((lCandidate = this.fMap.get(lFieldType)) == null) continue;
            boolean lOldAccessible = lField.isAccessible();
            try {
                lField.setAccessible(true);
                lField.set(pObject, lCandidate);
                if (lOldAccessible) continue;
                lField.setAccessible(false);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
        this.pWire(pObject, pClassLevel.getSuperclass());
    }
}

