/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.junit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import net.microfalx.lang.ArgumentUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.NullConsoleLogger;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="surefire")
@Singleton
public class SurefireTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurefireTests.class);
    private final Map<MavenProject, Collection<ReportTestSuite>> testSuites = new ConcurrentHashMap<MavenProject, Collection<ReportTestSuite>>();
    private int totalCount;
    private int successfulCount;
    private int failedCount;
    private int errorCount;
    private int skippedCount;
    private boolean loaded;

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getSuccessfulCount() {
        return this.successfulCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public Collection<MavenProject> getProjects() {
        return Collections.unmodifiableCollection(this.testSuites.keySet());
    }

    public Collection<ReportTestSuite> getTestSuites(MavenProject project) {
        ArgumentUtils.requireNonNull((Object)project);
        Collection<ReportTestSuite> testSuitesForProject = this.testSuites.get(project);
        return testSuitesForProject == null ? Collections.emptyList() : testSuitesForProject;
    }

    public void load(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        if (this.loaded) {
            return;
        }
        LOGGER.debug("Load surefire test suites");
        for (MavenProject project : session.getProjects()) {
            SurefireReportParser parser = this.createParser(project);
            if (parser == null) continue;
            List reportTestSuites = parser.parseXMLReportFiles();
            this.testSuites.put(project, reportTestSuites);
            this.updateStat(project, reportTestSuites);
        }
        LOGGER.debug("Loaded {} projects with tests", (Object)this.testSuites.size());
        this.loaded = true;
    }

    public void reset() {
        this.testSuites.clear();
        this.totalCount = 0;
        this.failedCount = 0;
        this.skippedCount = 0;
        this.errorCount = 0;
        this.successfulCount = 0;
        this.loaded = false;
    }

    private SurefireReportParser createParser(MavenProject project) {
        ArrayList<File> directories = new ArrayList<File>();
        this.appendDirectory(project, directories, "surefire-reports");
        this.appendDirectory(project, directories, "failsafe-reports");
        if (directories.isEmpty()) {
            return null;
        }
        return new SurefireReportParser(directories, (ConsoleLogger)new NullConsoleLogger());
    }

    private void appendDirectory(MavenProject project, List<File> directories, String subDirectory) {
        File directory = new File(new File(project.getBuild().getDirectory()), subDirectory);
        if (directory.exists()) {
            LOGGER.info("Load tests for project {} from {}", (Object)project.getName(), (Object)directory);
            directories.add(directory);
        }
    }

    private void updateStat(MavenProject project, List<ReportTestSuite> suites) {
        for (ReportTestSuite suite : suites) {
            LOGGER.debug("{} / {} = {}", new Object[]{project.getName(), suite.getName(), suite.getNumberOfTests()});
            this.totalCount += suite.getNumberOfTests();
            this.failedCount += suite.getNumberOfFailures();
            this.skippedCount += suite.getNumberOfSkipped();
            this.errorCount += suite.getNumberOfErrors();
            this.successfulCount += suite.getNumberOfTests() - suite.getNumberOfErrors() - suite.getNumberOfFailures();
        }
    }
}

