/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.FileUtils;
import net.microfalx.lang.Hashing;
import net.microfalx.lang.JvmUtils;
import net.microfalx.lang.StringUtils;
import net.microfalx.lang.TimeUtils;
import net.microfalx.lang.UriUtils;
import net.microfalx.resource.Credential;
import net.microfalx.resource.Resource;
import net.microfalx.resource.ResourceFactory;
import net.microfalx.resource.ResourceUtils;
import net.microfalx.resource.UserPasswordCredential;
import net.microfalx.talos.core.MavenUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenStorage.class);
    private static final String STORAGE_DIRECTORY = "talos";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final Duration MAX_WORKSPACE_RETENTION = Duration.ofDays(3L);
    private static final String TRENDS_DIRECTORY_NAME = "trends";
    private static final String SESSIONS_DIRECTORY_NAME = "sessions";
    private static final String STAGING_DIRECTORY_NAME = "staging";
    private static Resource storageDirectory;
    private static Resource sessionDirectory;
    private static Resource stagingDirectory;
    private static Resource trendDirectory;
    private static Resource remoteStorageDirectory;

    public static synchronized Resource getStorageDirectory() {
        if (storageDirectory == null) {
            File directory = JvmUtils.isHomeWritable() ? new File(JvmUtils.getCacheDirectory(), STORAGE_DIRECTORY) : new File(new File(JvmUtils.getTemporaryDirectory(), "microfalx"), STORAGE_DIRECTORY);
            storageDirectory = Resource.directory((File)FileUtils.validateDirectoryExists((File)directory));
        }
        return storageDirectory;
    }

    public static synchronized Resource getLocalSessionsDirectory() {
        return MavenStorage.getStorageDirectory().resolve(SESSIONS_DIRECTORY_NAME, Resource.Type.DIRECTORY);
    }

    public static synchronized Resource getStagingDirectory() {
        return MavenStorage.getStorageDirectory().resolve(STAGING_DIRECTORY_NAME, Resource.Type.DIRECTORY);
    }

    public static synchronized Resource getStagingDirectory(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        if (stagingDirectory == null) {
            stagingDirectory = MavenStorage.getStagingDirectory().resolve(MavenStorage.getBuildId(session));
        }
        return stagingDirectory;
    }

    public static synchronized Resource getLocalSessionsDirectory(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        if (sessionDirectory == null) {
            sessionDirectory = MavenStorage.getLocalSessionsDirectory().resolve(MavenStorage.getProjectId(session), Resource.Type.DIRECTORY).resolve(MavenStorage.getTimestampedName(session), Resource.Type.DIRECTORY);
        }
        return sessionDirectory;
    }

    public static synchronized Resource getRemoteSessionsDirectory(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        return MavenStorage.getRemoteStorage(session).resolve(SESSIONS_DIRECTORY_NAME, Resource.Type.DIRECTORY).resolve(MavenStorage.getProjectId(session), Resource.Type.DIRECTORY).resolve(MavenStorage.getTimestampedName(session), Resource.Type.DIRECTORY);
    }

    public static synchronized Resource getLocalTrendsDirectory(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        if (trendDirectory == null) {
            trendDirectory = MavenStorage.getStorageDirectory().resolve(TRENDS_DIRECTORY_NAME, Resource.Type.DIRECTORY).resolve(MavenStorage.getProjectId(session), Resource.Type.DIRECTORY);
        }
        return trendDirectory;
    }

    public static Resource storeTrend(MavenSession session, Resource trend) throws IOException {
        ArgumentUtils.requireNonNull((Object)session);
        ArgumentUtils.requireNonNull((Object)trend);
        String fileName = "trend_" + MavenStorage.getTimestampedName(session) + ".data";
        Resource resource = MavenStorage.getLocalTrendsDirectory(session).resolve(fileName);
        resource.copyFrom(trend);
        return resource;
    }

    public static void uploadTrend(MavenSession session, Resource trend) throws IOException {
        if (MavenStorage.hasRemoteStorage(session)) {
            Resource remoteTrendsDirectory = MavenStorage.getRemoteTrendsDirectory(session);
            Resource remoteTrend = remoteTrendsDirectory.resolve(trend.getFileName());
            remoteTrend.copyFrom(trend);
        }
    }

    public static Collection<Resource> getLocalTrends(MavenSession session) throws IOException {
        return MavenStorage.getLocalTrendsDirectory(session).list();
    }

    public static Collection<Resource> getRemoteTrends(MavenSession session) throws IOException {
        return MavenStorage.getRemoteTrendsDirectory(session).list();
    }

    public static boolean hasRemoteStorage(MavenSession session) {
        return ResourceUtils.exists((Resource)MavenStorage.getRemoteStorage(session));
    }

    public static Resource getRemoteStorage(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        if (remoteStorageDirectory == null) {
            Object uri = MavenUtils.getProperty(session, "storage.uri", (String)null);
            if (StringUtils.isNotEmpty((CharSequence)uri)) {
                boolean exist;
                String userName = MavenUtils.getProperty(session, "storage.username", (String)null);
                String password = MavenUtils.getProperty(session, "storage.password", (String)null);
                Credential credential = Credential.NA;
                if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)password)) {
                    credential = new UserPasswordCredential(userName, password);
                }
                LOGGER.info("Initialize remote storage, uri: {}, username {}", uri, (Object)StringUtils.defaultIfEmpty((String)userName, (String)"N/A"));
                String endpoint = null;
                String s3Bucket = MavenUtils.getProperty(session, "storage.s3.bucket", (String)null);
                String s3Prefix = MavenUtils.getProperty(session, "storage.s3.prefix", (String)null);
                if (StringUtils.isNotEmpty((CharSequence)s3Bucket)) {
                    endpoint = uri;
                    LOGGER.info("Use S3 bucket '{}', prefix '{}'", (Object)s3Bucket, (Object)StringUtils.defaultIfEmpty((String)s3Prefix, (String)"N/A"));
                    uri = "s3:/" + StringUtils.removeStartSlash((String)StringUtils.removeEndSlash((String)s3Bucket));
                    if (StringUtils.isNotEmpty((CharSequence)s3Prefix)) {
                        uri = (String)uri + "/" + StringUtils.removeStartSlash((String)StringUtils.removeEndSlash((String)s3Prefix));
                    }
                }
                remoteStorageDirectory = ResourceFactory.resolve((URI)UriUtils.parseUri((String)uri), (Credential)credential, (Resource.Type)Resource.Type.DIRECTORY);
                if (endpoint != null) {
                    remoteStorageDirectory = remoteStorageDirectory.withAttribute("endpoint", (Object)endpoint);
                }
                if (!(exist = ResourceUtils.exists((Resource)remoteStorageDirectory))) {
                    LOGGER.error("Remote storage '{}', credential {} does not exist or cannot be accessed", (Object)remoteStorageDirectory, (Object)credential);
                }
            } else {
                remoteStorageDirectory = Resource.NULL;
            }
        }
        return remoteStorageDirectory;
    }

    public static synchronized Resource getRemoteTrendsDirectory(MavenSession session) {
        return MavenStorage.getRemoteStorage(session).resolve(TRENDS_DIRECTORY_NAME, Resource.Type.DIRECTORY).resolve(MavenStorage.getProjectId(session), Resource.Type.DIRECTORY);
    }

    public static void cleanupWorkspace(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        MavenStorage.cleanupWorkspace(MavenStorage.getLocalSessionsDirectory());
        MavenStorage.cleanupWorkspace(MavenStorage.getStagingDirectory());
    }

    private static void cleanupWorkspace(Resource resource) {
        try {
            resource.walk((root, child) -> {
                if (MavenStorage.isOld(child.lastModified(), child.isFile())) {
                    try {
                        child.delete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getTimestampedName(MavenSession session) {
        Date date = session.getStartTime();
        LocalDateTime startTime = LocalDateTime.now();
        if (date != null) {
            TimeUtils.toLocalDateTime((Object)date);
        }
        return DATE_FORMATTER.format(startTime);
    }

    private static String getProjectId(MavenSession session) {
        if (session.getTopLevelProject() == null) {
            throw new IllegalArgumentException("The session does not have a project attached");
        }
        MavenProject project = session.getTopLevelProject();
        return project.getGroupId() + "." + project.getArtifactId();
    }

    private static String getBuildId(MavenSession session) {
        Hashing hashing = Hashing.create();
        hashing.update((Object)session.getRequest().getBaseDirectory());
        return StringUtils.toIdentifier((String[])new String[]{MavenStorage.getTimestampedName(session), hashing.asString()});
    }

    private static boolean isOld(long timestamp, boolean file) {
        Duration age = Duration.ofMillis(System.currentTimeMillis() - timestamp);
        return age.compareTo(file ? MAX_WORKSPACE_RETENTION : MAX_WORKSPACE_RETENTION.plusDays(1L)) > 0;
    }
}

