/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.ClassUtils;
import net.microfalx.lang.ExceptionUtils;
import net.microfalx.lang.IOUtils;
import net.microfalx.resource.Resource;
import net.microfalx.talos.core.MavenConfiguration;
import net.microfalx.talos.core.MavenStorage;
import net.microfalx.talos.core.MavenUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.eclipse.sisu.Priority;
import org.joor.Reflect;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

@Named
@Singleton
@Priority(value=1000)
public class MavenLogger
extends AbstractMavenLifecycleParticipant {
    private static final String LOGGER_PREFIX = "build.";
    private static final int LOG_LEVEL_OFF = 50;
    private final Logger logger;
    private final StringBuilder buffer = new StringBuilder(8000);
    private MavenConfiguration configuration;
    private PrintStream originalSystemOutputPrintStream;
    private Resource systemOutputResource;
    private PrintStream systemOutputPrintStream;
    private PrintStream originalSystemErrorPrintStream;
    private Resource systemErrorResource;
    private PrintStream systemErrorPrintStream;
    @Inject
    protected MavenSession session;

    public static MavenLogger create(Class<?> clazz) {
        return MavenLogger.create(LoggerFactory.getLogger(clazz));
    }

    public static MavenLogger create(Logger logger) {
        return new MavenLogger(logger);
    }

    public MavenLogger() {
        this(LoggerFactory.getLogger(MavenLogger.class));
        this.originalSystemOutputPrintStream = System.out;
        this.originalSystemErrorPrintStream = System.err;
    }

    public PrintStream getSystemOutputPrintStream() {
        return this.originalSystemOutputPrintStream;
    }

    public Resource getSystemOutput() {
        this.flushSystemStreams();
        return this.systemOutputResource;
    }

    public Resource getSystemError() {
        this.flushSystemStreams();
        return this.systemErrorResource;
    }

    private MavenLogger(Logger logger) {
        ArgumentUtils.requireNonNull((Object)logger);
        this.logger = logger;
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void debug(String format, Object ... arguments) {
        this.logger.debug(format, arguments);
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
    }

    public void info(String message) {
        this.logger.info(message);
        this.append(message);
    }

    public void info(String format, Object ... arguments) {
        this.logger.info(format, arguments);
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.append(message);
    }

    public void warn(String message) {
        this.logger.warn(message);
        this.append(message);
    }

    public void warn(String format, Object ... arguments) {
        this.logger.warn(format, arguments);
        String message = MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage();
        this.append(message);
    }

    public String getReport() {
        return this.buffer.toString();
    }

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        super.afterSessionStart(session);
        this.configuration = new MavenConfiguration(session);
        this.initSystemStreams();
        this.initLogging();
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        super.afterSessionEnd(session);
        this.releaseSystemStreams();
    }

    private void append(String message) {
        this.buffer.append(message).append('\n');
    }

    private void initSystemStreams() {
        Resource stagingDirectory = MavenStorage.getStagingDirectory(this.configuration.getSession());
        this.systemOutputResource = stagingDirectory.resolve("build.output.log", Resource.Type.FILE);
        this.systemErrorResource = stagingDirectory.resolve("build.error.log", Resource.Type.FILE);
        this.debug("Initialize loggers to " + String.valueOf(this.systemOutputResource.toURI()));
        try {
            OutputStream systemOutputResourceStream = this.systemOutputResource.getOutputStream();
            if (!this.configuration.isQuiet()) {
                systemOutputResourceStream = new TeeOutputStream(systemOutputResourceStream, (OutputStream)this.originalSystemOutputPrintStream);
            }
            this.systemOutputPrintStream = new PrintStream(systemOutputResourceStream, true);
            System.setOut(this.systemOutputPrintStream);
            OutputStream systemErrorResourceStream = this.systemErrorResource.getOutputStream();
            if (!this.configuration.isQuiet()) {
                systemErrorResourceStream = new TeeOutputStream(systemErrorResourceStream, (OutputStream)this.originalSystemErrorPrintStream);
            }
            this.systemErrorPrintStream = new PrintStream(systemErrorResourceStream, true);
            System.setErr(this.systemErrorPrintStream);
        }
        catch (IOException e) {
            this.warn("Failed to initialize system output stream, root cause: {}", ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void releaseSystemStreams() {
        IOUtils.closeQuietly((OutputStream)this.systemOutputPrintStream);
        IOUtils.closeQuietly((OutputStream)this.systemErrorPrintStream);
    }

    private void flushSystemStreams() {
        this.systemOutputPrintStream.flush();
        this.systemErrorPrintStream.flush();
    }

    void initLogging() {
        if (!MavenUtils.isMavenLoggerAvailable()) {
            return;
        }
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            if (!"org.slf4j.impl.MavenSimpleLoggerFactory".equals(ClassUtils.getName((Object)loggerFactory))) {
                return;
            }
            Object config = Reflect.onClass((String)"org.slf4j.impl.SimpleLogger").get("CONFIG_PARAMS");
            Object outputChoice = Reflect.onClass((String)"org.slf4j.impl.OutputChoice").create(new Object[]{this.systemOutputPrintStream}).get();
            Reflect.on((Object)config).set("outputChoice", outputChoice);
        }
        catch (NoClassDefFoundError e) {
            this.logger.warn("Failed to initialize logging, root cause: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

