/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.core;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.ClassUtils;
import net.microfalx.lang.ExceptionUtils;
import net.microfalx.metrics.Timer;
import net.microfalx.talos.core.MavenUtils;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenTracker {
    private final Class<?> clazz;
    private final Logger logger;
    private static final Collection<Failure> failures = new LinkedBlockingDeque<Failure>();

    public static Collection<Failure> getFailures() {
        return Collections.unmodifiableCollection(failures);
    }

    public static void reset() {
        failures.clear();
    }

    public MavenTracker(Class<?> clazz) {
        ArgumentUtils.requireNonNull(clazz);
        this.clazz = clazz;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public <T> void track(String name, Consumer<T> consumer) {
        this.track(name, consumer, null);
    }

    public <T> T trackCallable(String name, Callable<T> callable) {
        return this.track(name, callable, null, null);
    }

    public <T> void track(String name, Consumer<T> consumer, MavenProject project) {
        this.track(name, consumer, project, null);
    }

    public <T> void track(String name, Supplier<T> supplier) {
        try {
            MavenUtils.METRICS.time(name, supplier);
        }
        catch (Exception e) {
            this.logFailure(name, e);
        }
    }

    public <T> T track(String name, Callable<T> consumer, MavenProject project, Mojo mojo) {
        try {
            return (T)MavenUtils.METRICS.timeCallable(name, consumer);
        }
        catch (Exception e) {
            this.logFailure(name, e, project, mojo);
            return null;
        }
    }

    public <T> void track(String name, Consumer<T> consumer, MavenProject project, Mojo mojo) {
        try {
            MavenUtils.METRICS.time(name, t -> consumer.accept(null));
        }
        catch (Exception e) {
            this.logFailure(name, e, project, mojo);
        }
    }

    public Duration getDuration() {
        return Duration.ofNanos(MavenUtils.METRICS.getTimers().stream().map(Timer::getDuration).mapToLong(Duration::toNanos).sum());
    }

    public void logFailure(String name, Throwable throwable) {
        this.logFailure(name, throwable, null, null);
    }

    public void logFailure(String name, Throwable throwable, MavenProject project, Mojo mojo) {
        failures.add(new Failure(name, project, mojo, throwable));
        Object stackTrace = "";
        if (throwable != null) {
            stackTrace = ", stack trace\n" + ExceptionUtils.getStackTrace((Throwable)throwable);
        }
        this.logger.error("Failed action '{}' in '{}'{}", new Object[]{name, ClassUtils.getName(this.clazz), stackTrace});
    }

    static {
        Metrics.addRegistry((MeterRegistry)new SimpleMeterRegistry());
    }

    public static class Failure {
        private final String name;
        private final MavenProject project;
        private final Mojo mojo;
        private final Throwable throwable;

        Failure(String name, MavenProject project, Mojo mojo, Throwable throwable) {
            this.name = name;
            this.project = project;
            this.mojo = mojo;
            this.throwable = throwable;
        }

        public String getName() {
            return this.name;
        }

        public MavenProject getProject() {
            return this.project;
        }

        public Mojo getMojo() {
            return this.mojo;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

