/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.core;

import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.ClassUtils;
import net.microfalx.lang.FormatterUtils;
import net.microfalx.lang.NumberUtils;
import net.microfalx.lang.ObjectUtils;
import net.microfalx.lang.StringUtils;
import net.microfalx.lang.TimeUtils;
import net.microfalx.lang.UriUtils;
import net.microfalx.metrics.Metrics;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

public class MavenUtils {
    private static final String PROPERTY_PREFIX = "talos.";
    public static Metrics METRICS = Metrics.of((String)"Talos");
    public static final String ZERO_DURATION = "~0s";
    private static final int DURATION_LENGTH = 9;
    private static final Map<String, String> mojoNames = new ConcurrentHashMap<String, String>();
    private static final Set<String> secretNames = new HashSet<String>();
    private static final String SECRET_MASK = "*********************";

    public static boolean isLoggerAvailable() {
        return MavenUtils.isMavenLoggerAvailable();
    }

    public static boolean isMavenLoggerAvailable() {
        return ClassUtils.exists((String)"org.slf4j.impl.MavenSimpleLoggerFactory");
    }

    public static String getId(Artifact artifact) {
        ArgumentUtils.requireNonNull((Object)artifact);
        return StringUtils.toIdentifier((String)(artifact.getGroupId() + ":" + artifact.getArtifactId()));
    }

    public static String getId(org.apache.maven.artifact.Artifact artifact) {
        ArgumentUtils.requireNonNull((Object)artifact);
        return StringUtils.toIdentifier((String)(artifact.getGroupId() + ":" + artifact.getArtifactId()));
    }

    public static String getId(Dependency dependency) {
        ArgumentUtils.requireNonNull((Object)dependency);
        return StringUtils.toIdentifier((String)(dependency.getGroupId() + ":" + dependency.getArtifactId()));
    }

    public static String getId(Plugin plugin) {
        ArgumentUtils.requireNonNull((Object)plugin);
        return StringUtils.toIdentifier((String)(plugin.getGroupId() + ":" + plugin.getArtifactId()));
    }

    public static String getId(Mojo mojo) {
        ArgumentUtils.requireNonNull((Object)mojo);
        return StringUtils.toIdentifier((String)ClassUtils.getName((Object)mojo));
    }

    public static String getId(MavenProject project) {
        return StringUtils.toIdentifier((String)(project.getGroupId() + ":" + project.getArtifactId()));
    }

    public static String getId(Metadata metadata) {
        return StringUtils.toIdentifier((String)(metadata.getGroupId() + ":" + metadata.getArtifactId()));
    }

    public static String formatInteger(int value, int length) {
        return MavenUtils.formatInteger(value, length, true);
    }

    public static String formatInteger(int value, int length, boolean digits) {
        return MavenUtils.leftPad(Integer.toString(value), length, digits ? (char)'0' : ' ');
    }

    public static String leftPad(String text, int length) {
        return MavenUtils.leftPad(text, length, ' ');
    }

    public static String leftPad(String text, int length, char fill) {
        if (((String)(text = StringUtils.defaultIfNull((String)text, (String)""))).length() < length) {
            text = StringUtils.getStringOfChar((char)fill, (int)(length - ((String)text).length())) + (String)text;
        }
        return text;
    }

    public static String formatDuration(Duration duration) {
        return MavenUtils.formatDuration(duration, true, true);
    }

    public static String formatDuration(Duration duration, boolean brackets) {
        return MavenUtils.formatDuration(duration, brackets, true);
    }

    public static String formatDuration(Duration duration, boolean brackets, boolean padding) {
        int padSize;
        String durationAsString;
        StringBuilder builder = new StringBuilder();
        if (brackets) {
            builder.append("[");
        }
        String string = durationAsString = duration.toMillis() == 0L ? ZERO_DURATION : MavenUtils.formatDuration(duration.toMillis());
        if (padding && (padSize = 9 - durationAsString.length()) > 0) {
            builder.append(StringUtils.getStringOfChar((char)' ', (int)padSize));
        }
        builder.append(durationAsString);
        if (brackets) {
            builder.append(']');
        }
        return builder.toString();
    }

    public static String formatDuration(long duration) {
        long ms = duration % 1000L;
        long s = duration / 1000L % 60L;
        long m = duration / 60000L % 60L;
        long h = duration / 3600000L % 24L;
        String format = h > 0L ? "%1$02d:%2$02dh" : (m > 0L ? "%2$02d:%3$02dm" : "%3$d.%4$03ds");
        return String.format(format, h, m, s, ms);
    }

    public static String formatMemory(long used, long maximum) {
        return FormatterUtils.formatBytes((Object)used) + " of " + FormatterUtils.formatBytes((Object)maximum) + " (" + FormatterUtils.formatPercent((Object)Float.valueOf(NumberUtils.percent((float)used, (float)maximum))) + ")";
    }

    public static Duration getProperty(MavenSession session, String name, Duration defaultValue) {
        String value = MavenUtils.getProperty(session, name, (String)null);
        try {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return TimeUtils.parseDuration((String)value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static boolean getProperty(MavenSession session, String name, boolean defaultValue) {
        String value = MavenUtils.getProperty(session, name, (String)null);
        try {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static int getProperty(MavenSession session, String name, int defaultValue) {
        String value = MavenUtils.getProperty(session, name, (String)null);
        try {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static String getProperty(MavenSession session, String name, String defaultValue) {
        ArgumentUtils.requireNonNull((Object)session);
        ArgumentUtils.requireNonNull((Object)name);
        name = PROPERTY_PREFIX + (String)name;
        String envVar = StringUtils.replaceAll((String)((String)name).toUpperCase(), (String)".", (String)"_");
        String value = System.getenv(envVar);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        value = session.getSystemProperties().getProperty((String)name);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        MavenProject project = session.getCurrentProject();
        if (project == null) {
            project = session.getTopLevelProject();
        }
        if (project != null) {
            value = ObjectUtils.toString((Object)project.getProperties().get(name));
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return defaultValue;
    }

    public static void registerName(String mojoClass, String name) {
        ArgumentUtils.requireNotEmpty((Object)mojoClass);
        ArgumentUtils.requireNotEmpty((Object)name);
        mojoNames.put(mojoClass.toLowerCase(), name);
    }

    public static String getName(Mojo mojo) {
        ArgumentUtils.requireNonNull((Object)mojo);
        String name = mojoNames.get(mojo.getClass().getName().toLowerCase());
        if (name != null) {
            return name;
        }
        name = StringUtils.replaceFirst((String)mojo.getClass().getSimpleName(), (String)"Mojo", (String)"");
        return StringUtils.beautifyCamelCase((String)name);
    }

    public static String getGoal(MojoExecution execution) {
        ArgumentUtils.requireNonNull((Object)execution);
        MojoDescriptor descriptor = execution.getMojoDescriptor();
        Object prefix = descriptor.getPluginDescriptor().getGoalPrefix();
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            Plugin plugin = execution.getPlugin();
            prefix = plugin.getGroupId() + ":" + plugin.getArtifactId();
        }
        return (String)prefix + ":" + execution.getGoal();
    }

    public static Collection<URI> getRemoteRepositories(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        return session.getRequest().getRemoteRepositories().stream().map(ArtifactRepository::getUrl).map(UriUtils::parseUri).collect(Collectors.toList());
    }

    public static String maskSecret(String name, String value) {
        if (name == null || value == null) {
            return null;
        }
        if (MavenUtils.hasHost(value)) {
            return MavenUtils.maskUri(value);
        }
        if (MavenUtils.isSecret(name)) {
            return SECRET_MASK;
        }
        return value;
    }

    public static boolean isSecret(String name) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        for (String secretName : secretNames) {
            if (!name.contains(secretName)) continue;
            return true;
        }
        return false;
    }

    private static String maskUri(String uri) {
        if (MavenUtils.hasHost(uri)) {
            try {
                URI parsedUri = UriUtils.parseUri((String)uri);
                return new URI(parsedUri.getScheme(), "secret.domain", parsedUri.getPath(), parsedUri.getQuery(), parsedUri.getFragment()).toASCIIString();
            }
            catch (Exception e) {
                return "Error: Invalid URI";
            }
        }
        return uri;
    }

    private static boolean hasHost(String uri) {
        return uri.contains("://");
    }

    static {
        MavenUtils.registerName("org.jacoco.maven.AgentMojo", "Jacoco Agent");
        MavenUtils.registerName("org.jacoco.maven.ReportMojo", "Jacoco Report");
        MavenUtils.registerName("org.apache.maven.plugin.resources.remote.ProcessRemoteResourcesMojo", "Remote Resources");
        MavenUtils.registerName("org.apache.maven.plugin.surefire.SurefireMojo", "Unit Tests");
        secretNames.add("password");
        secretNames.add("keypass");
        secretNames.add("secret");
        secretNames.add("login");
        secretNames.add("gpg");
        secretNames.add("apikey");
        secretNames.add("bearer");
        secretNames.add("api_key");
    }
}

