/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.talos.core;

import java.io.File;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.FileUtils;
import net.microfalx.lang.StringUtils;
import net.microfalx.resource.Resource;
import net.microfalx.talos.core.MavenUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

public class MavenConfiguration {
    private static final int VERBOSE_NONE = 0;
    private static final int VERBOSE_SOME = 1;
    private static final int VERBOSE_MORE = 2;
    private static final int VERBOSE_ALL = 3;
    private Boolean verbose;
    private Boolean quiet;
    private Boolean progress;
    private Integer verbosityLevel;
    private final MavenSession session;

    public MavenConfiguration(MavenSession session) {
        ArgumentUtils.requireNonNull((Object)session);
        this.session = session;
    }

    public final MavenSession getSession() {
        return this.session;
    }

    public final boolean isQuiet() {
        if (this.quiet == null) {
            this.quiet = MavenUtils.getProperty(this.session, "quiet", true);
        }
        return this.quiet != false || this.isMavenQuiet();
    }

    public boolean isMavenQuiet() {
        return this.session.getRequest().getLoggingLevel() >= 3;
    }

    public final boolean isVerbose() {
        if (this.verbose == null) {
            this.initVerbose();
        }
        return this.verbose;
    }

    public final boolean isProgress() {
        if (this.progress == null) {
            this.progress = MavenUtils.getProperty(this.session, "progress", true);
        }
        return this.progress != false && this.isQuiet() && MavenUtils.isMavenLoggerAvailable() && !this.isMavenQuiet();
    }

    public boolean isQuietAndWithProgress() {
        return this.isQuiet() && this.isProgress();
    }

    public boolean isParallel() {
        return this.getDop() > 1;
    }

    public int getDop() {
        return this.session.getRequest().getDegreeOfConcurrency();
    }

    public Resource getTargetDirectory(String name, boolean topLevel) {
        return Resource.directory((File)FileUtils.validateDirectoryExists((File)this.getTargetReference(name, topLevel)));
    }

    public Resource getTargetFile(String name, boolean topLevel) {
        return Resource.file((File)FileUtils.validateFileExists((File)this.getTargetReference(name, topLevel)));
    }

    public Resource getTargetDirectory(MavenProject project, String name) {
        return Resource.directory((File)FileUtils.validateDirectoryExists((File)this.getTargetReference(project, name)));
    }

    public Resource getTargetFile(MavenProject project, String name) {
        return Resource.file((File)FileUtils.validateFileExists((File)this.getTargetReference(project, name)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getTargetReference(String name, boolean topLevel) {
        if (topLevel) {
            MavenProject project = this.session.getTopLevelProject();
            if (project == null) return StringUtils.isNotEmpty((CharSequence)name) ? new File(this.getTargetFromRequest(), name) : this.getTargetFromRequest();
            return this.getTargetReference(project, name);
        }
        MavenProject project = this.session.getCurrentProject();
        if (project == null) throw new IllegalArgumentException("A target reference (" + name + ") cannot retrieved since project information is not available");
        return this.getTargetReference(project, name);
    }

    private File getTargetReference(MavenProject project, String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return new File(project.getBuild().getDirectory());
        }
        return new File(project.getBuild().getDirectory(), name);
    }

    private File getTargetFromRequest() {
        File baseDirectory = new File(this.session.getRequest().getBaseDirectory());
        return new File(baseDirectory, "target");
    }

    private void initVerbose() {
        this.verbose = MavenUtils.getProperty(this.session, "verbose", false);
        this.verbosityLevel = MavenUtils.getProperty(this.session, "verboseLevel", 0);
        if (this.verbose.booleanValue()) {
            this.verbosityLevel = 3;
        }
    }

    private void initProgress() {
    }
}

