/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.boot;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class BootstrapUtils {
    public static <T> T requireNonNull(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be NULL");
        }
        return value;
    }

    public static String formatBytes(long value) {
        return value / 0x100000L + "MB";
    }

    public static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence value) {
        return !BootstrapUtils.isEmpty(value);
    }

    public static File validateDirectoryExists(File directory) {
        BootstrapUtils.requireNonNull(directory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.exists()) {
            BootstrapUtils.throwException(new IllegalStateException("Directory '" + directory.getAbsolutePath() + "' could not be created"));
        }
        return directory;
    }

    public static <T> T throwException(Throwable exception) {
        BootstrapUtils.doThrowException(exception);
        return null;
    }

    private static <E extends Throwable> void doThrowException(Throwable exception) throws E {
        BootstrapUtils.requireNonNull(exception);
        throw exception;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "N/A";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }
}

