/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.boot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.microfalx.boot.ApplicationBuilder;
import net.microfalx.boot.BootstrapClassLoader;
import net.microfalx.boot.BootstrapUtils;

public class Bootstrap {
    private static final int EXIT_CODE = 10;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final LocalDateTime startupTime = LocalDateTime.now();
    private final ApplicationBuilder applicationBuilder = new ApplicationBuilder();
    private final StringBuilder log = new StringBuilder();
    private Writer writer;
    private final boolean logConsole = Bootstrap.getSystemProperty("log", false);
    private Method mainMethod;
    private int exitCode = 10;
    private String[] args;
    private static Bootstrap instance;

    static Bootstrap get() {
        if (instance == null) {
            instance = new Bootstrap(false);
        }
        return instance;
    }

    public Bootstrap() {
        this(true);
    }

    Bootstrap(boolean init) {
        instance = this;
        if (init) {
            this.initLog();
        }
    }

    public String getLog() {
        return this.log.toString();
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void log(String message) {
        if (this.logConsole) {
            System.out.println((String)message);
        }
        this.log.append((String)message).append('\n');
        Duration millisSinceStart = Duration.between(this.startupTime, LocalDateTime.now());
        LocalDateTime time = LocalDate.now().atStartOfDay().plus(millisSinceStart);
        message = "[" + FORMATTER.format(time) + "] " + (String)message;
        if (this.writer != null) {
            try {
                this.writer.append((CharSequence)message).append('\n');
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void log(String format, Object ... args) {
        if (args.length == 0) {
            this.log(format);
        } else {
            this.log(MessageFormat.format(format, args));
        }
    }

    void start(String[] args) {
        this.log("Starting application, home directory ''{0}''", this.applicationBuilder.getHome().getAbsolutePath());
        this.init(args);
        this.run();
    }

    public void init(String[] args) {
        if (args == null || args.length == 0) {
            this.log("At least one parameters is required, target main class name");
            this.abort();
            return;
        }
        String mainClassName = args[0];
        if (args.length - 1 > 0) {
            this.args = new String[args.length - 1];
            System.arraycopy(args, 1, this.args, 0, args.length - 1);
        } else {
            this.args = new String[0];
        }
        this.getPidFile().delete();
        BootstrapClassLoader classLoader = new BootstrapClassLoader(this.applicationBuilder.getClassPath(), ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Class<?> mainClass = Class.forName(mainClassName, false, classLoader);
            this.mainMethod = mainClass.getMethod("main", String[].class);
            this.log("Application class ''{0}'' loaded successfully", mainClassName);
        }
        catch (ClassNotFoundException e) {
            this.log("Application class ''{0}'' does not exists", mainClassName);
        }
        catch (NoSuchMethodException e) {
            this.log("Application class ''{0}'' does not have a main method", mainClassName);
        }
        catch (Exception e) {
            this.log("Application class ''{0}'' could not be loaded", mainClassName);
        }
        if (this.mainMethod == null) {
            this.abort();
        }
    }

    public void run() {
        if (this.mainMethod == null) {
            return;
        }
        if (this.args.length > 0) {
            this.log("Startup parameters:");
            for (String arg : this.args) {
                this.log("  - \"{0}\"", arg);
            }
        }
        try {
            this.mainMethod.invoke(null, new Object[]{this.args});
            this.log("Application started successfully, PID=" + this.getPid());
            this.writePid();
        }
        catch (Exception e) {
            this.log("Failed to start the application, stack trace\n{0}", BootstrapUtils.getStackTrace(e));
            this.abort();
        }
    }

    private void initLog() {
        try {
            this.writer = new FileWriter(new File(this.applicationBuilder.getLogsDirectory(), "boot.log"));
        }
        catch (IOException e) {
            System.err.println("Failed to create bootstrap logger, root cause: " + e.getMessage());
        }
    }

    private void abort() {
        if (this.exitCode > 0) {
            System.exit(this.exitCode);
        }
    }

    private File getPidFile() {
        return new File(this.applicationBuilder.getTmpDirectory(), ".pid");
    }

    private void writePid() {
        try (FileWriter writer = new FileWriter(this.getPidFile());){
            writer.write(Long.toString(this.getPid()));
        }
        catch (IOException e) {
            this.log("Failed to write PID file, root cause: " + e.getMessage());
        }
    }

    private long getPid() {
        return ProcessHandle.current().pid();
    }

    static String getSystemProperty(String name) {
        return System.getProperty("talos." + name);
    }

    static boolean getSystemProperty(String name, boolean defaultValue) {
        String value = Bootstrap.getSystemProperty(name);
        if (BootstrapUtils.isNotEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.start(args);
    }
}

