/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.boot;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.microfalx.boot.Bootstrap;
import net.microfalx.boot.BootstrapException;
import net.microfalx.boot.BootstrapUtils;

public class ApplicationBuilder {
    private final Collection<File> files = new ArrayList<File>();
    private File home;
    private File libDirectory;
    private File logsDirectory;
    private File tmpDirectory;

    public ApplicationBuilder() {
        this.initDirectories();
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        BootstrapUtils.requireNonNull(home);
        this.updateHome(home);
    }

    public File getLibDirectory() {
        return this.libDirectory;
    }

    public File getLogsDirectory() {
        return this.logsDirectory;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public URL[] getClassPath() {
        this.discoverFiles();
        return this.files.stream().map(ApplicationBuilder::toUrl).collect(Collectors.toList()).toArray(new URL[0]);
    }

    private void discoverFiles() {
        this.files.clear();
        File[] jars = this.libDirectory.listFiles((dir, name) -> name.endsWith(".jar"));
        Bootstrap.get().log("Build class path from ''{0}''", this.libDirectory.getAbsolutePath());
        if (jars != null) {
            long totalSize = Arrays.stream(jars).mapToLong(File::length).sum();
            Bootstrap.get().log("Found {0} libraries, size {1}", jars.length, BootstrapUtils.formatBytes(totalSize));
            this.files.addAll(Arrays.asList(jars));
        }
    }

    private void initDirectories() {
        String home = Bootstrap.getSystemProperty("home");
        if (BootstrapUtils.isNotEmpty(home)) {
            this.updateHome(new File(home));
        } else {
            home = System.getenv("HOME");
            if (BootstrapUtils.isEmpty(home)) {
                throw new IllegalStateException("Environment variable HOME does not exist");
            }
            this.updateHome(new File(home));
        }
    }

    private void updateHome(File home) {
        BootstrapUtils.requireNonNull(home);
        this.home = home;
        if (!this.home.exists()) {
            throw new IllegalStateException("Home directory '" + String.valueOf(this.home) + "' does not exist");
        }
        this.libDirectory = new File(home, "lib");
        if (!this.libDirectory.exists()) {
            throw new IllegalStateException("A directory with libraries (" + String.valueOf(this.libDirectory) + ") does not exist");
        }
        this.tmpDirectory = new File(home, "tmp");
        if (!this.tmpDirectory.exists()) {
            throw new IllegalStateException("A directory for temporary files (" + String.valueOf(this.tmpDirectory) + ") does not exist");
        }
        this.logsDirectory = new File(home, "logs");
        if (!this.logsDirectory.exists()) {
            BootstrapUtils.validateDirectoryExists(this.logsDirectory);
        }
    }

    private static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new BootstrapException(e);
        }
    }
}

