/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.resource.s3;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.Item;
import io.minio.messages.Owner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.ClassUtils;
import net.microfalx.lang.CollectionUtils;
import net.microfalx.lang.ExceptionUtils;
import net.microfalx.lang.FileUtils;
import net.microfalx.lang.IOUtils;
import net.microfalx.lang.JvmUtils;
import net.microfalx.lang.ObjectUtils;
import net.microfalx.lang.StringUtils;
import net.microfalx.lang.TimeUtils;
import net.microfalx.lang.UriUtils;
import net.microfalx.metrics.Metrics;
import net.microfalx.resource.AbstractStatefulResource;
import net.microfalx.resource.Credential;
import net.microfalx.resource.Resource;
import net.microfalx.resource.ResourceException;
import net.microfalx.resource.ResourceResolver;
import net.microfalx.resource.ResourceUtils;
import net.microfalx.resource.ResourceVisitor;
import net.microfalx.resource.StatefulResource;
import net.microfalx.resource.UserPasswordCredential;
import net.microfalx.resource.s3.S3Exception;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

public class S3Resource
extends AbstractStatefulResource<MinioClient, MinioClient> {
    private static final Metrics METRICS = ResourceUtils.METRICS.withGroup("S3");
    private static volatile URL defaultEndpoint = UriUtils.parseUrl((String)"https://s3.amazonaws.com");
    private URL endpoint;
    private final URI uri;
    private volatile Boolean bucketExists;
    private volatile StatObjectResponse stats;
    private volatile long lastStatsUpdate;
    private volatile Long lastModified;
    private volatile Long size;
    private volatile String etag;
    private volatile String owner;
    private static final String NO_SUCH_BUCKET = "NoSuchBucket";
    private static final String NO_SUCH_KEY = "NoSuchKey";

    public static StatefulResource file(URI uri, Credential credential) {
        return S3Resource.create(Resource.Type.FILE, uri, credential);
    }

    public static StatefulResource directory(URI uri, Credential credential) {
        return S3Resource.create(Resource.Type.DIRECTORY, uri, credential);
    }

    public static StatefulResource create(URI uri, Credential credential) {
        ArgumentUtils.requireNonNull((Object)uri);
        String path = uri.getPath();
        String id = ResourceUtils.hash((String)uri.toASCIIString());
        Resource.Type type = ResourceUtils.getTypeFromPath((String)path, null);
        return S3Resource.create(type, uri, credential);
    }

    public static StatefulResource create(Resource.Type type, URI uri, Credential credential) {
        ArgumentUtils.requireNonNull((Object)type);
        ArgumentUtils.requireNonNull((Object)uri);
        ArgumentUtils.requireNonNull((Object)credential);
        String id = ResourceUtils.hash((String)uri.toASCIIString());
        S3Resource resource = new S3Resource(type, id, uri);
        resource.setCredential(credential);
        return resource;
    }

    public static void setDefaultEndpoint(URL url) {
        ArgumentUtils.requireNonNull((Object)url);
        defaultEndpoint = url;
    }

    public static URL getDefaultEndpoint() {
        return defaultEndpoint;
    }

    private S3Resource(Resource.Type type, String id, URI uri) {
        super(type, id);
        ArgumentUtils.requireNonNull((Object)uri);
        this.uri = uri;
        if (StringUtils.isEmpty((CharSequence)uri.getPath())) {
            throw new S3Exception("The URI path must contain at least the bucket");
        }
        this.setAbsolutePath(false);
    }

    public URL getEndpoint() {
        if (this.endpoint == null) {
            Object value = this.getAttribute("endpoint");
            if (ObjectUtils.isEmpty((Object)value)) {
                value = defaultEndpoint;
            }
            if (ObjectUtils.isEmpty((Object)value)) {
                throw new S3Exception("The endpoint was not provided and the default end point was not set");
            }
            this.endpoint = this.toUrl(value);
        }
        return this.endpoint;
    }

    public String getFileName() {
        return FileUtils.getFileName((String)this.uri.getPath());
    }

    public String getEtag() throws IOException {
        if (this.etag != null && !this.areStatsStale()) {
            return this.etag;
        }
        StatObjectResponse currentStats = this.getStats();
        return currentStats != null ? currentStats.etag() : null;
    }

    public String getOwner() throws IOException {
        return this.owner;
    }

    public boolean doExists() throws IOException {
        this.checkBucket();
        if (StringUtils.isEmpty((CharSequence)this.getObjectPath())) {
            return this.bucketExists;
        }
        StatObjectResponse currentStats = this.getStats();
        return currentStats != null && currentStats.lastModified() != null;
    }

    protected long doLastModified() throws IOException {
        if (this.lastModified != null && !this.areStatsStale()) {
            return this.lastModified;
        }
        StatObjectResponse currentStats = this.getStats();
        return currentStats != null && currentStats.lastModified() != null ? TimeUtils.toMillis((Temporal)currentStats.lastModified()) : 0L;
    }

    protected long doLength() throws IOException {
        if (this.size != null && !this.areStatsStale()) {
            return this.size;
        }
        StatObjectResponse currentStats = this.getStats();
        return currentStats != null && currentStats.lastModified() != null ? currentStats.size() : 0L;
    }

    protected void doCreate() throws IOException {
    }

    protected void doCreateParents() throws IOException {
    }

    protected void doDelete() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.getObjectPath())) {
            return;
        }
        this.doWithChannel("delete", channel -> {
            try {
                RemoveObjectArgs args = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectPath())).build();
                channel.removeObject(args);
                this.clearCache();
            }
            catch (ErrorResponseException e) {
                if (S3Resource.isMissingError(e)) {
                    return null;
                }
                throw new S3Exception(this.getErrorMessage("Failed to delete object stats from ''{0}'' for ''{1}''"), e);
            }
            return null;
        });
    }

    protected InputStream doGetInputStream(boolean raw) throws IOException {
        return (InputStream)this.doWithChannel("input stream", channel -> {
            GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectPath())).build();
            return channel.getObject(args);
        });
    }

    protected OutputStream doGetOutputStream() throws IOException {
        File file = JvmUtils.getTemporaryFile((String)"s3.", (String)".object");
        OutputStream delegate = IOUtils.getBufferedOutputStream((File)file);
        return new S3OutputStream(file, delegate);
    }

    protected Collection<Resource> doList() throws IOException {
        return (Collection)this.doWithChannel("list", channel -> {
            ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.getBucketName())).prefix(StringUtils.addEndSlash((String)this.getObjectPath())).build();
            Iterable results = channel.listObjects(args);
            return CollectionUtils.toList((Iterator)new ItemIterator(this, results.iterator()));
        });
    }

    protected boolean doWalk(ResourceVisitor visitor, int maxDepth) throws IOException {
        return (Boolean)this.doWithChannel("walk", channel -> {
            ListObjectsArgs args = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.getBucketName())).prefix(StringUtils.addEndSlash((String)this.getObjectPath())).delimiter("/").recursive(true).build();
            Iterable results = channel.listObjects(args);
            ItemIterator iterator = new ItemIterator(this, results.iterator());
            boolean loop = true;
            while (iterator.hasNext() && loop) {
                Resource child = iterator.next();
                String path = child.getPath((Resource)this);
                if (StringUtils.split((String)path, (String)"/").length > maxDepth) continue;
                loop = visitor.onResource((Resource)this, child);
            }
            return loop;
        });
    }

    public Resource resolve(String path) {
        ArgumentUtils.requireNonNull((Object)path);
        Resource.Type type = ResourceUtils.getTypeFromPath((String)path);
        return this.resolve(path, type);
    }

    public Resource resolve(String path, Resource.Type type) {
        ArgumentUtils.requireNonNull((Object)path);
        ArgumentUtils.requireNonNull((Object)type);
        String newUri = StringUtils.addEndSlash((String)this.uri.toASCIIString()) + path;
        return this.createFromUri(newUri, type);
    }

    public Resource get(String path, Resource.Type type) {
        ArgumentUtils.requireNonNull((Object)path);
        ArgumentUtils.requireNonNull((Object)type);
        try {
            URI newUri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, null, null);
            return this.createFromUri(newUri.toASCIIString(), type);
        }
        catch (URISyntaxException e) {
            throw new ResourceException("Invalid resource URL for path '" + path + "', original URI '" + String.valueOf(this.uri) + "'", (Throwable)e);
        }
    }

    public URI toURI() {
        return this.uri;
    }

    protected MinioClient doCreateSession() throws Exception {
        MinioClient.Builder builder = MinioClient.builder().endpoint(this.getEndpoint());
        Credential credential = this.getCredential();
        if (!(credential instanceof UserPasswordCredential)) {
            throw new IllegalArgumentException("Unexpected credential type " + credential.getClass().getName());
        }
        UserPasswordCredential userPasswordCredential = (UserPasswordCredential)credential;
        builder.credentials(userPasswordCredential.getUserName(), userPasswordCredential.getPassword());
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(5L)).connectTimeout(Duration.ofSeconds(5L)).readTimeout(Duration.ofSeconds(30L));
        builder.httpClient(clientBuilder.build(), true);
        return builder.build();
    }

    protected void doReleaseSession(MinioClient session) throws Exception {
        session.close();
    }

    protected boolean isValid(MinioClient session) throws Exception {
        return true;
    }

    protected MinioClient doCreateChannel(MinioClient session) throws Exception {
        return session;
    }

    protected void doReleaseChannel(MinioClient session, MinioClient channel) throws Exception {
    }

    protected IOException translateException(Exception e) {
        return new IOException("Failed to perform S3 operation", e);
    }

    protected Metrics getMetrics() {
        return METRICS;
    }

    private Resource createFromUri(String uri, Resource.Type type) {
        S3Resource resource = (S3Resource)S3Resource.create(type, URI.create(uri), this.getCredential());
        resource.bucketExists = this.bucketExists;
        resource.endpoint = this.endpoint;
        return resource;
    }

    private void uploadFile(File file) throws IOException {
        this.doWithChannel("output stream", channel -> {
            channel.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectPath())).filename(file.getAbsolutePath()).build());
            return null;
        });
        this.clearCache();
    }

    private S3Resource update(ZonedDateTime lastModified, Long size, String etag, String owner) {
        this.etag = etag;
        this.owner = owner;
        this.size = size;
        this.lastModified = lastModified != null ? Long.valueOf(TimeUtils.toMillis((Temporal)lastModified)) : null;
        return this;
    }

    private String getBucketName() {
        if (StringUtils.isEmpty((CharSequence)this.getPath())) {
            return null;
        }
        return StringUtils.split((String)this.getPath(), (String)"/")[0];
    }

    private String getObjectPath() {
        CharSequence[] parts = StringUtils.split((String)this.getPath(), (String)"/");
        if (parts.length < 2) {
            return null;
        }
        parts = Arrays.copyOfRange(parts, 1, parts.length);
        return String.join((CharSequence)"/", parts);
    }

    private StatObjectResponse getStats() throws IOException {
        if (this.stats == null || this.areStatsStale()) {
            this.stats = (StatObjectResponse)this.doWithChannel("exists", channel -> {
                try {
                    StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.getBucketName())).object(this.getObjectPath())).build();
                    return channel.statObject(args);
                }
                catch (ErrorResponseException e) {
                    if (S3Resource.isMissingError(e)) {
                        return null;
                    }
                    throw new S3Exception(this.getErrorMessage("Failed to retrieve object stats from ''{0}'' for ''{1}''"), e);
                }
            });
            this.lastStatsUpdate = System.currentTimeMillis();
        }
        return this.stats;
    }

    private static boolean isMissingError(ErrorResponseException e) {
        String code = e.errorResponse().code();
        return NO_SUCH_KEY.equals(code) || NO_SUCH_BUCKET.equals(code);
    }

    private String getErrorMessage(String format) {
        return StringUtils.formatMessage((String)format, (Object[])new Object[]{this.getEndpoint(), this.toURI().getPath()});
    }

    private boolean areStatsStale() {
        return TimeUtils.millisSince((Object)this.lastStatsUpdate) > 60000L;
    }

    private void checkBucket() throws IOException {
        if (this.bucketExists == null) {
            boolean found = (Boolean)this.doWithChannel("bucket exists", channel -> {
                BucketExistsArgs args = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.getBucketName())).build();
                return channel.bucketExists(args);
            });
            if (!found) {
                this.doWithChannel("make bucket", channel -> {
                    MakeBucketArgs args = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.getBucketName())).build();
                    channel.makeBucket(args);
                    return null;
                });
            }
            this.bucketExists = true;
        }
    }

    private URL toUrl(Object value) {
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof URI) {
            try {
                return ((URI)value).toURL();
            }
            catch (MalformedURLException e) {
                return (URL)ExceptionUtils.throwException((Throwable)e);
            }
        }
        if (value instanceof String) {
            return this.toUrl(URI.create((String)value));
        }
        throw new IllegalArgumentException("Unknown endpoint type: " + ClassUtils.getName((Object)value));
    }

    private void clearCache() {
        this.bucketExists = null;
        this.stats = null;
        this.lastModified = null;
        this.size = null;
    }

    private class S3OutputStream
    extends OutputStream {
        private final File file;
        private final OutputStream delegate;

        public S3OutputStream(File file, OutputStream delegate) {
            this.file = file;
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            try {
                S3Resource.this.uploadFile(this.file);
            }
            catch (Exception e) {
                FileUtils.remove((File)this.file);
            }
        }
    }

    private static class ItemIterator
    implements Iterator<Resource> {
        private final S3Resource parent;
        private final Iterator<Result<Item>> items;

        public ItemIterator(S3Resource parent, Iterator<Result<Item>> items) {
            ArgumentUtils.requireNonNull((Object)((Object)parent));
            ArgumentUtils.requireNonNull(items);
            this.parent = parent;
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.items.hasNext();
        }

        private String cleanupEtag(String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }

        private String cleanupOwner(Owner owner) {
            if (owner == null) {
                return null;
            }
            return owner.id();
        }

        @Override
        public Resource next() {
            try {
                Resource object;
                Item item = (Item)this.items.next().get();
                String etag = this.cleanupEtag(item.etag());
                String owner = this.cleanupOwner(item.owner());
                ZonedDateTime lastModified = ZonedDateTime.now();
                try {
                    lastModified = item.lastModified();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String name = FileUtils.getFileName((String)StringUtils.removeStartSlash((String)item.objectName()));
                if (item.isDir()) {
                    object = this.parent.resolve(name, Resource.Type.DIRECTORY);
                    ((S3Resource)object).update(lastModified, null, etag, owner);
                } else {
                    object = this.parent.resolve(name, Resource.Type.FILE);
                    ((S3Resource)object).update(lastModified, item.size(), etag, owner);
                }
                return object;
            }
            catch (Exception e) {
                return (Resource)ExceptionUtils.throwException((Throwable)e);
            }
        }
    }

    public static class S3ResourceResolver
    implements ResourceResolver {
        public boolean supports(URI uri) {
            return "s3".equalsIgnoreCase(uri.getScheme()) || "s3+tls".equalsIgnoreCase(uri.getScheme());
        }

        public Resource resolve(URI uri, Resource.Type type) {
            return S3Resource.create(type, uri, Credential.NA).withFragment(uri.getFragment());
        }
    }
}

