/*
 * Decompiled with CFR 0.152.
 */
package net.microfalx.resource.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import net.microfalx.lang.ArgumentUtils;
import net.microfalx.lang.FileUtils;
import net.microfalx.lang.StringUtils;
import net.microfalx.metrics.Metrics;
import net.microfalx.resource.AbstractStatefulResource;
import net.microfalx.resource.Credential;
import net.microfalx.resource.Resource;
import net.microfalx.resource.ResourceException;
import net.microfalx.resource.ResourceResolver;
import net.microfalx.resource.ResourceUtils;
import net.microfalx.resource.StatefulResource;
import net.microfalx.resource.UserPasswordCredential;
import net.microfalx.resource.s3.S3Utilities;

public class S3Resource
extends AbstractStatefulResource<AmazonS3Client, AmazonS3Client> {
    private static final Metrics METRICS = ResourceUtils.METRICS.withGroup("S3");
    private final URI uri;

    public static StatefulResource file(URI uri, Credential credential) {
        return S3Resource.create(Resource.Type.FILE, uri, credential);
    }

    public static StatefulResource directory(URI uri, Credential credential) {
        return S3Resource.create(Resource.Type.DIRECTORY, uri, credential);
    }

    public static StatefulResource create(URI uri, Credential credential) {
        ArgumentUtils.requireNonNull((Object)uri);
        String path = uri.getPath();
        String id = ResourceUtils.hash((String)uri.toASCIIString());
        Resource.Type type = ResourceUtils.getTypeFromPath((String)path, null);
        return S3Resource.create(type, uri, credential);
    }

    public static StatefulResource create(Resource.Type type, URI uri, Credential credential) {
        ArgumentUtils.requireNonNull((Object)type);
        ArgumentUtils.requireNonNull((Object)uri);
        ArgumentUtils.requireNonNull((Object)credential);
        String id = ResourceUtils.hash((String)uri.toASCIIString());
        S3Resource resource = new S3Resource(type, id, uri);
        resource.setCredential(credential);
        return resource;
    }

    private S3Resource(Resource.Type type, String id, URI uri) {
        super(type, id);
        ArgumentUtils.requireNonNull((Object)uri);
        this.uri = uri;
        this.setAbsolutePath(false);
    }

    public String getFileName() {
        return FileUtils.getFileName((String)this.uri.getPath());
    }

    public boolean doExists() throws IOException {
        return false;
    }

    protected long doLastModified() throws IOException {
        return 0L;
    }

    protected long doLength() throws IOException {
        return 0L;
    }

    protected Collection<Resource> doList() throws IOException {
        return Collections.emptyList();
    }

    public Resource resolve(String path) {
        ArgumentUtils.requireNonNull((Object)path);
        Resource.Type type = ResourceUtils.getTypeFromPath((String)path);
        return this.resolve(path, type);
    }

    public Resource resolve(String path, Resource.Type type) {
        ArgumentUtils.requireNonNull((Object)path);
        ArgumentUtils.requireNonNull((Object)type);
        String newUri = StringUtils.addEndSlash((String)this.uri.toASCIIString()) + path;
        return this.createFromUri(newUri, type);
    }

    public Resource get(String path, Resource.Type type) {
        ArgumentUtils.requireNonNull((Object)path);
        ArgumentUtils.requireNonNull((Object)type);
        try {
            URI newUri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, null, null);
            return this.createFromUri(newUri.toASCIIString(), type);
        }
        catch (URISyntaxException e) {
            throw new ResourceException("Invalid resource URL for path '" + path + "', original URI '" + String.valueOf(this.uri) + "'", (Throwable)e);
        }
    }

    public URI toURI() {
        return this.uri;
    }

    protected AmazonS3Client doCreateSession() throws Exception {
        S3ClientOptions clientOptions = S3ClientOptions.builder().setPathStyleAccess(true).build();
        Credential credential = this.getCredential();
        if (!(credential instanceof UserPasswordCredential)) {
            throw new IllegalArgumentException("Unexpected credential type " + credential.getClass().getName());
        }
        UserPasswordCredential userPasswordCredential = (UserPasswordCredential)credential;
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(userPasswordCredential.getUserName(), userPasswordCredential.getPassword());
        AmazonS3Client client = new AmazonS3Client((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials));
        client.setEndpoint(this.createEndpoint());
        client.setS3ClientOptions(clientOptions);
        return client;
    }

    protected void doReleaseSession(AmazonS3Client session) throws Exception {
    }

    protected boolean isValid(AmazonS3Client session) throws Exception {
        return false;
    }

    protected AmazonS3Client doCreateChannel(AmazonS3Client session) throws Exception {
        return session;
    }

    protected void doReleaseChannel(AmazonS3Client session, AmazonS3Client channel) throws Exception {
    }

    protected IOException translateException(Exception e) {
        return null;
    }

    protected Metrics getMetrics() {
        return METRICS;
    }

    private <R> R doWithChannel(AbstractStatefulResource.ChannelCallback<AmazonS3Client, R> callback) throws IOException {
        ArgumentUtils.requireNonNull(callback);
        AmazonS3Client session = (AmazonS3Client)this.createSession();
        AmazonS3Client channel = null;
        try {
            channel = (AmazonS3Client)this.createChannel(session);
            Object object = callback.doWithChannel((Object)channel);
            return (R)object;
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        finally {
            this.releaseChannel(session, channel);
        }
    }

    private String createEndpoint() {
        StringBuffer endPoint = new StringBuffer();
        endPoint.append(S3Utilities.isSecure(this.uri) ? "https" : "http");
        endPoint.append("://").append(this.uri.getHost());
        if (this.uri.getPort() > 0) {
            endPoint.append(this.uri.getPath());
        }
        endPoint.append(this.uri.getPath());
        return endPoint.toString();
    }

    private Resource createFromUri(String uri, Resource.Type type) {
        return S3Resource.create(type, URI.create(uri), this.getCredential());
    }

    public static class S3ResourceResolver
    implements ResourceResolver {
        public boolean supports(URI uri) {
            return "s3".equalsIgnoreCase(uri.getScheme()) || "s3+tls".equalsIgnoreCase(uri.getScheme());
        }

        public Resource resolve(URI uri, Resource.Type type) {
            return S3Resource.create(type, uri, Credential.NA).withFragment(uri.getFragment());
        }
    }
}

