/*
 * Decompiled with CFR 0.152.
 */
package net.micedre.keycloak.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.micedre.keycloak.registration.RegistrationUserCreationDomainValidation;
import org.keycloak.authentication.FormContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.provider.ProviderConfigProperty;

public class RegistrationUserCreationWithMailDomainCheck
extends RegistrationUserCreationDomainValidation {
    public static final String PROVIDER_ID = "registration-mail-check-action";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    public static String domainListConfigName = "validDomains";

    public String getDisplayType() {
        return "Profile Validation with email domain check";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Adds validation of domain emails for registration";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        List<String> authorizedMailDomains = Arrays.asList(context.getAuthenticatorConfig().getConfig().getOrDefault(domainListConfigName, "example.org").split("##"));
        form.setAttribute("authorizedMailDomains", authorizedMailDomains);
    }

    @Override
    public String[] getDomainList(AuthenticatorConfigModel mailDomainConfig) {
        return mailDomainConfig.getConfig().getOrDefault(domainListConfigName, "example.org").split("##");
    }

    @Override
    public boolean isEmailValid(String email, String[] domains) {
        for (String domain : domains) {
            if (!email.endsWith("@" + domain) && !email.equals(domain) && !RegistrationUserCreationWithMailDomainCheck.globmatches(email, "*@" + domain)) continue;
            return true;
        }
        return false;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(domainListConfigName);
        property.setLabel("Valid domains for emails");
        property.setType("String");
        property.setHelpText("List mail domains authorized to register, separated by '##'");
        CONFIG_PROPERTIES.add(property);
    }
}

