/*
 * Decompiled with CFR 0.152.
 */
package net.micedre.keycloak.registration;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.authentication.forms.RegistrationUserCreation;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.utils.FormMessage;

public abstract class RegistrationUserCreationDomainValidation
extends RegistrationUserCreation
implements FormAction {
    protected static final Logger logger = Logger.getLogger(RegistrationUserCreationDomainValidation.class);
    protected static final String DEFAULT_DOMAIN_LIST = "example.org";
    protected static final String DOMAIN_LIST_SEPARATOR = "##";

    public boolean isConfigurable() {
        return true;
    }

    public void success(FormContext context) {
    }

    protected static final boolean globmatches(String text, String glob) {
        int i;
        if (text.length() > 200) {
            return false;
        }
        String rest = null;
        int pos = glob.indexOf(42);
        if (pos != -1) {
            rest = glob.substring(pos + 1);
            glob = glob.substring(0, pos);
        }
        if (glob.length() > text.length()) {
            return false;
        }
        for (i = 0; i < glob.length(); ++i) {
            if (glob.charAt(i) == '?' || glob.substring(i, i + 1).equalsIgnoreCase(text.substring(i, i + 1))) continue;
            return false;
        }
        if (rest == null) {
            return glob.length() == text.length();
        }
        for (i = glob.length(); i <= text.length(); ++i) {
            if (!RegistrationUserCreationDomainValidation.globmatches(text.substring(i), rest)) continue;
            return true;
        }
        return false;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        String email = (String)formData.getFirst((Object)"email");
        AuthenticatorConfigModel mailDomainConfig = context.getAuthenticatorConfig();
        String eventError = "invalid_registration";
        if (email == null) {
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "invalidEmailMessage"));
            context.error(eventError);
            context.validationError(formData, errors);
            return;
        }
        String[] domainList = this.getDomainList(mailDomainConfig);
        boolean emailDomainValid = this.isEmailValid(email, domainList);
        if (!emailDomainValid) {
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "invalidEmailMessage"));
        }
        if (errors.size() > 0) {
            context.error(eventError);
            context.validationError(formData, errors);
        } else {
            context.success();
        }
    }

    public abstract String[] getDomainList(AuthenticatorConfigModel var1);

    public abstract boolean isEmailValid(String var1, String[] var2);
}

