/*
 * Decompiled with CFR 0.152.
 */
package net.micedre.keycloak.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.micedre.keycloak.registration.RegistrationProfileDomainValidation;
import org.keycloak.authentication.FormContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.provider.ProviderConfigProperty;

public class RegistrationProfileWithDomainBlock
extends RegistrationProfileDomainValidation {
    public static final String PROVIDER_ID = "registration-domain-block-action";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    public static String domainListConfigName = "invalidDomains";

    public String getDisplayType() {
        return "Profile Validation with domain block";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Adds validation of not accepted domain emails for registration";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        List<String> unauthorizedMailDomains = Arrays.asList(context.getAuthenticatorConfig().getConfig().getOrDefault(domainListConfigName, "example.org").split("##"));
        form.setAttribute("unauthorizedMailDomains", unauthorizedMailDomains);
    }

    @Override
    public String[] getDomainList(AuthenticatorConfigModel mailDomainConfig) {
        return mailDomainConfig.getConfig().getOrDefault(domainListConfigName, "example.org").split("##");
    }

    @Override
    public boolean isEmailValid(String email, String[] domains) {
        for (String domain : domains) {
            if (!email.endsWith("@" + domain) && !email.equals(domain) && !RegistrationProfileWithDomainBlock.globmatches(email, "*@" + domain)) continue;
            return false;
        }
        return true;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(domainListConfigName);
        property.setLabel("Invalid domain for emails");
        property.setType("String");
        property.setHelpText("List mail domains not authorized to register, separated by '##'");
        CONFIG_PROPERTIES.add(property);
    }
}

