/*
 * Decompiled with CFR 0.152.
 */
package net.micedre.keycloak.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.authentication.forms.RegistrationProfile;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;

public class RegistrationProfileWithMailDomainCheck
extends RegistrationProfile
implements FormAction {
    public static final String PROVIDER_ID = "registration-mail-check-action";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public String getDisplayType() {
        return "Profile Validation with email domain check";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isConfigurable() {
        return true;
    }

    public String getHelpText() {
        return "Adds validation of domain emails for registration";
    }

    private static final boolean globmatches(String text, String glob) {
        int i;
        if (text.length() > 200) {
            return false;
        }
        String rest = null;
        int pos = glob.indexOf(42);
        if (pos != -1) {
            rest = glob.substring(pos + 1);
            glob = glob.substring(0, pos);
        }
        if (glob.length() > text.length()) {
            return false;
        }
        for (i = 0; i < glob.length(); ++i) {
            if (glob.charAt(i) == '?' || glob.substring(i, i + 1).equalsIgnoreCase(text.substring(i, i + 1))) continue;
            return false;
        }
        if (rest == null) {
            return glob.length() == text.length();
        }
        for (i = glob.length(); i <= text.length(); ++i) {
            if (!RegistrationProfileWithMailDomainCheck.globmatches(text.substring(i), rest)) continue;
            return true;
        }
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void validate(ValidationContext context) {
        String[] domains;
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        ArrayList<FormMessage> errors = new ArrayList<FormMessage>();
        String email = (String)formData.getFirst((Object)"email");
        boolean emailDomainValid = false;
        AuthenticatorConfigModel mailDomainConfig = context.getAuthenticatorConfig();
        String eventError = "invalid_registration";
        if (email == null) {
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "invalidEmailMessage"));
            context.error(eventError);
            context.validationError(formData, errors);
            return;
        }
        for (String domain : domains = mailDomainConfig.getConfig().getOrDefault("validDomains", "exemple.org").split("##")) {
            if (email.endsWith("@" + domain)) {
                emailDomainValid = true;
                break;
            }
            if (!RegistrationProfileWithMailDomainCheck.globmatches(email, "*@" + domain)) continue;
            emailDomainValid = true;
            break;
        }
        if (!emailDomainValid) {
            context.getEvent().detail("email", email);
            errors.add(new FormMessage("email", "invalidEmailMessage"));
        }
        if (errors.size() > 0) {
            context.error(eventError);
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        List<String> authorizedMailDomains = Arrays.asList(context.getAuthenticatorConfig().getConfig().getOrDefault("validDomains", "exemple.org").split("##"));
        form.setAttribute("authorizedMailDomains", authorizedMailDomains);
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("validDomains");
        property.setLabel("Valid domain for emails");
        property.setType("MultivaluedString");
        property.setHelpText("List mail domains authorized to register");
        CONFIG_PROPERTIES.add(property);
    }
}

