/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.net.caldav;

import com.github.caldav4j.methods.HttpPropFindMethod;
import com.github.caldav4j.util.UrlUtils;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCalDAV {
    private static final Logger log = LoggerFactory.getLogger(TestCalDAV.class);

    public static void main(String[] args) throws IOException, DavException {
        MultiStatusResponse[] e;
        HashMap<String, Object> info = new HashMap<String, Object>();
        HttpClient http = TestCalDAV.createHttpClient("https://" + System.getProperty("caldav.user") + ":" + System.getProperty("caldav.password") + "@remote.mfjassociates.net/owa/", info);
        http = TestCalDAV.createHttpClient("https://" + System.getProperty("caldav.user") + ":" + System.getProperty("caldav.password") + "@www.google.com/calendar/dav/marioja/", info);
        String collection = "collection_changeme/";
        String collectionPath = UrlUtils.removeDoubleSlashes((String)((String)info.get("home") + collection));
        HttpHost hostConfig = new HttpHost((String)info.get("host"), ((Integer)info.get("port")).intValue(), (String)info.get("protocol"));
        DavPropertyNameSet set = new DavPropertyNameSet();
        DavPropertyName resourcetype = DavPropertyName.create((String)"resourcetype");
        set.add(resourcetype);
        HttpPropFindMethod propFindMethod = new HttpPropFindMethod(collectionPath, set, Integer.MAX_VALUE);
        HttpResponse httpResponse = http.execute(hostConfig, (HttpRequest)propFindMethod);
        for (MultiStatusResponse response : e = propFindMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
            DavPropertySet properties = response.getProperties(200);
            log.info("HREF: " + response.getHref());
            for (DavProperty property : properties) {
                String nodeName = property.getName().toString();
                log.info("nodename: " + nodeName + "\nvalue: " + property.getValue());
            }
        }
    }

    public static HttpClient createHttpClient(String uri, Map<String, Object> info) {
        String user = null;
        String password = null;
        try {
            URI server = new URI(uri);
            String protocol = server.getScheme().replaceAll("://", "");
            info.put("protocol", protocol);
            String host = server.getHost();
            info.put("host", host);
            int port = server.getPort();
            info.put("port", port);
            String home = server.getPath().replace("\\w+/$", "");
            home = UrlUtils.ensureTrailingSlash((String)home);
            info.put("home", home);
            String userInfo = server.getUserInfo();
            if (userInfo != null) {
                user = userInfo.split(":")[0];
                password = userInfo.split(":")[1];
            }
        }
        catch (Exception server) {
            // empty catch block
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }
}

