/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.jai;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.jfif.JfifDirectory;
import com.sun.javafx.iio.ImageStorageException;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import net.mfjassociates.fx.FXUtils;
import net.mfjassociates.jai.PreferencesController;
import net.mfjassociates.jai.util.ImageHandler;
import org.apache.commons.math3.util.Precision;

public class ImageUtilController {
    private static final String LAST_DIRECTORY_PREF = "last_directory";
    private static final String APPLICATION_INFORMATION = "Application Information";
    private Preferences userPreferences = Preferences.userNodeForPackage(this.getClass());
    @FXML
    private ImageView imageView;
    @FXML
    private Label statusMessageLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private RadioMenuItem metadataMenu;
    @FXML
    private RadioMenuItem base64Menu;
    @FXML
    private Label resolutionLabel;
    @FXML
    private ScrollPane leftsp;
    @FXML
    private ScrollPane rightsp;
    @FXML
    private SplitPane splitPane;
    @FXML
    private ContextMenu leftContextMenu;
    @FXML
    private ContextMenu rightContextMenu;
    private byte[] imageBytes = null;
    private InputStream bais = null;
    private String imageName = null;
    private PreferencesController preferencesController = null;
    private PreferencesController.JaiPreferences jaiPrefs = new PreferencesController.JaiPreferences(this.userPreferences);
    private FileChooser.ExtensionFilter[] imageIOBasedExtensionFilters = this.createImageIOBasedExtensionFilter();
    private FileChooser.ExtensionFilter selectedExtensionFilter = null;
    private Text base64Label = new Text();
    private GridPane metadataGridPane = new GridPane();
    private IntegerProperty xdensity = new SimpleIntegerProperty(-1);
    private IntegerProperty ydensity = new SimpleIntegerProperty(-1);
    private BooleanProperty leftVisible = new SimpleBooleanProperty(false);
    private boolean visibleInProgress = false;

    @FXML
    private void initialize() {
        this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
        this.metadataGridPane.hgapProperty().set(3.0);
        this.metadataGridPane.vgapProperty().set(3.0);
        this.metadataGridPane.visibleProperty().set(false);
        this.metadataMenu.disableProperty().bind((ObservableValue)this.metadataGridPane.visibleProperty().not());
        this.base64Label.wrappingWidthProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return ((Bounds)ImageUtilController.this.leftsp.viewportBoundsProperty().get()).getWidth();
            }
        });
        this.leftsp.setContent((Node)this.metadataGridPane);
        this.leftsp.visibleProperty().bind((ObservableValue)this.leftsp.managedProperty());
        this.leftsp.managedProperty().bind((ObservableValue)new BooleanBinding(){
            private Animation animation;
            {
                this.animation = new Transition(){
                    {
                        this.setCycleDuration(Duration.millis((double)500.0));
                    }

                    protected void interpolate(double frac) {
                        if (Precision.equals((double)frac, (double)1.0, (int)4)) {
                            ImageUtilController.this.leftVisible.set(true);
                        }
                    }
                };
            }

            protected boolean computeValue() {
                DoubleProperty divPos = ((SplitPane.Divider)ImageUtilController.this.splitPane.getDividers().get(0)).positionProperty();
                if (divPos.get() > 0.1) {
                    if (!ImageUtilController.this.leftVisible.get()) {
                        this.animation.playFromStart();
                        ImageUtilController.this.visibleInProgress = true;
                    } else if (!ImageUtilController.this.visibleInProgress) {
                        ImageUtilController.this.leftVisible.set(false);
                    }
                } else {
                    ImageUtilController.this.leftVisible.set(false);
                }
                if (ImageUtilController.this.leftVisible.get()) {
                    ImageUtilController.this.visibleInProgress = false;
                }
                return ImageUtilController.this.leftVisible.get();
            }
        });
        this.leftsp.setOnContextMenuRequested(event -> {
            this.leftContextMenu.show((Node)this.leftsp, event.getScreenX(), event.getScreenY());
            event.consume();
        });
        this.rightsp.setOnContextMenuRequested(event -> {
            this.rightContextMenu.show((Node)this.rightsp, event.getScreenX(), event.getScreenY());
            event.consume();
        });
        this.resolutionLabel.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                String result = null;
                if (ImageUtilController.this.xdensity.get() != -1 && ImageUtilController.this.ydensity.get() != -1) {
                    result = String.format(" xres: %1$d, yres: %2$d", ImageUtilController.this.xdensity.get(), ImageUtilController.this.ydensity.get());
                }
                return result;
            }
        });
    }

    public final int getXdensity() {
        return this.xdensity.get();
    }

    public final void setXdensity(int anXdensity) {
        this.xdensity.set(anXdensity);
    }

    public final IntegerProperty xdensityProperty() {
        return this.xdensity;
    }

    public final int getYdensity() {
        return this.ydensity.get();
    }

    public final void setYdensity(int aYdensity) {
        this.ydensity.set(aYdensity);
    }

    public final IntegerProperty ydensityProperty() {
        return this.ydensity;
    }

    @FXML
    private void closeFired(ActionEvent event) {
        Platform.exit();
    }

    private Object createControllerForType(Class<?> type) {
        if (this.preferencesController == null) {
            this.preferencesController = new PreferencesController(this.userPreferences, this.imageView);
        }
        return this.preferencesController;
    }

    @FXML
    private void preferencesFired(ActionEvent event) throws IOException {
        Dialog dialog = new Dialog();
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("Preferences.fxml"));
        loader.setControllerFactory(this::createControllerForType);
        DialogPane dialogPane = (DialogPane)loader.load();
        dialog.setDialogPane(dialogPane);
        PreferencesController pc = (PreferencesController)loader.getController();
        pc.setDialog((Dialog<PreferencesController.JaiPreferences>)dialog);
        Optional result = null;
        try {
            result = dialog.showAndWait();
        }
        catch (RuntimeException t) {
            t.printStackTrace();
        }
        if (result != null && result.isPresent()) {
            this.jaiPrefs = (PreferencesController.JaiPreferences)result.get();
            if (this.jaiPrefs.getDisplayCompression().isModified()) {
                this.setupImageTask();
            }
        }
    }

    @FXML
    private void aboutFired(ActionEvent event) {
        Package p = this.getClass().getPackage();
        Alert alert = new Alert(Alert.AlertType.INFORMATION, String.format("Application Name: %1$s%nVendor: %2$s%nVersion: %3$s", p.getImplementationTitle(), p.getImplementationVendor(), p.getImplementationVersion()), new ButtonType[0]);
        alert.setHeaderText(APPLICATION_INFORMATION);
        alert.setTitle("About");
        alert.showAndWait();
    }

    @FXML
    private void base64Fired(ActionEvent event) {
        Platform.runLater(() -> this.leftsp.setContent((Node)this.base64Label));
    }

    @FXML
    private void metadataFired(ActionEvent event) {
        Platform.runLater(() -> this.leftsp.setContent((Node)this.metadataGridPane));
    }

    @FXML
    private void openFired(ActionEvent event) throws IOException {
        File imageFile = this.configureFileChooser("Open Image File", this.imageView.getScene().getWindow(), DIALOG_TYPE.open);
        if (imageFile != null) {
            this.setupImage(imageFile);
        }
    }

    private void setupImage(File imageFile) {
        ImageReadByChunks imageReadByChunk = new ImageReadByChunks();
        imageReadByChunk.setImageFile(imageFile);
        FXUtils.ProgressResponsiveTask readImageFileTask = new FXUtils.ProgressResponsiveTask(rt -> {
            this.imageBytes = (byte[])rt.getValue();
            this.bais = new ByteArrayInputStream(this.imageBytes);
            this.imageName = imageFile.getName();
            this.setupImageTask();
            this.progressBar.setVisible(false);
            this.progressBar.progressProperty().unbind();
            return false;
        }, rt -> {
            if (rt.getException() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                rt.getException().printStackTrace(new PrintStream(baos));
                this.statusMessageLabel.setText(baos.toString());
            }
            this.progressBar.setVisible(false);
            this.progressBar.progressProperty().unbind();
            return null;
        }, imageReadByChunk::applyThrows, this.imageView.getScene(), imageFile.length());
        this.progressBar.setProgress(0.0);
        this.progressBar.progressProperty().bind((ObservableValue)readImageFileTask.progressProperty());
        this.progressBar.setVisible(true);
        Thread readImageFileThread = new Thread((Runnable)readImageFileTask);
        readImageFileThread.setDaemon(true);
        readImageFileThread.start();
    }

    private void loadBase64Task(ImageInformation ii) {
        Task<String> loadBase64Task = new Task<String>(){

            protected String call() throws Exception {
                Platform.runLater(() -> ImageUtilController.this.statusMessageLabel.setText("Creating base 64 string..."));
                return new String(Base64.getEncoder().encode(ImageUtilController.this.imageBytes));
            }
        };
        loadBase64Task.setOnSucceeded(arg_0 -> this.lambda$loadBase64Task$6((Task)loadBase64Task, ii, arg_0));
        Thread base64Thread = new Thread((Runnable)loadBase64Task);
        base64Thread.setDaemon(true);
        base64Thread.start();
    }

    private void setupImageTask() {
        FXUtils.ResponsiveTask setupImageTask = new FXUtils.ResponsiveTask(rt -> {
            ImageInformation ii = (ImageInformation)rt.getValue();
            if (ii == null) {
                return true;
            }
            this.populateMetadata(ii.metadata);
            if (!this.metadataGridPane.isVisible()) {
                this.metadataMenu.setSelected(false);
                this.base64Menu.setSelected(true);
            }
            this.imageView.setImage(ii.fximage);
            this.statusMessageLabel.setText(String.format("Image %1$s: image size=%2$s, base64 size=%3$,d, type=%4$s, compression=%5$f", this.imageName, ii.imageSize, 0, ii.formatName, this.jaiPrefs.getDisplayCompression().get()));
            this.loadBase64Task(ii);
            return true;
        }, rt -> {
            if (rt.getException() != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                rt.getException().printStackTrace(new PrintStream(baos));
                this.statusMessageLabel.setText(baos.toString());
            }
            return null;
        }, this::setupImage, this.imageView.getScene());
        this.imageView.setImage(null);
        this.base64Label.setText(null);
        this.metadataGridPane.visibleProperty().set(false);
        Thread setupThread = new Thread((Runnable)setupImageTask);
        setupThread.setDaemon(true);
        setupThread.start();
    }

    private void populateMetadata(Metadata metadata) {
        if (metadata == null) {
            this.metadataGridPane.visibleProperty().set(false);
            return;
        }
        int row = 0;
        this.metadataGridPane.getChildren().clear();
        this.metadataGridPane.add((Node)LabelInitializer.getLabel("Directory"), 0, row);
        this.metadataGridPane.add((Node)LabelInitializer.getLabel("Tag Id"), 1, row);
        this.metadataGridPane.add((Node)LabelInitializer.getLabel("Tag Name"), 2, row);
        this.metadataGridPane.add((Node)LabelInitializer.getLabel("Extracted Value"), 3, row);
        ++row;
        for (Directory dir : metadata.getDirectories()) {
            for (Tag tag : dir.getTags()) {
                this.metadataGridPane.add((Node)LabelInitializer.getLabel(tag.getDirectoryName()), 0, row);
                this.metadataGridPane.add((Node)LabelInitializer.getLabel(tag.getTagTypeHex()), 1, row);
                this.metadataGridPane.add((Node)LabelInitializer.getLabel(tag.getTagName()), 2, row);
                this.metadataGridPane.add((Node)LabelInitializer.getLabel(tag.getDescription()), 3, row);
                ++row;
            }
            if (!dir.hasErrors()) continue;
            for (String error : dir.getErrors()) {
                Label errorLabel = LabelInitializer.getLabel(error);
                GridPane.setColumnSpan((Node)errorLabel, (Integer)4);
                this.metadataGridPane.add((Node)errorLabel, 0, row);
                ++row;
            }
        }
        JfifDirectory jfif = (JfifDirectory)metadata.getFirstDirectoryOfType(JfifDirectory.class);
        if (jfif != null) {
            try {
                this.xdensityProperty().set(jfif.getInt(8));
                this.ydensityProperty().set(jfif.getInt(10));
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        this.metadataGridPane.visibleProperty().set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImageInformation setupImage() throws IOException {
        if (this.imageBytes == null) {
            return null;
        }
        Image fximage = null;
        Metadata localMetadata = null;
        this.jaiPrefs.getResizeWidth().reset();
        this.jaiPrefs.getResizeHeight().reset();
        this.bais.reset();
        try {
            this.bais.reset();
            localMetadata = ImageMetadataReader.readMetadata((InputStream)this.bais);
        }
        catch (ImageProcessingException imageProcessingException) {
        }
        finally {
            this.bais.reset();
        }
        ImageInputStream imageis = ImageIO.createImageInputStream(this.bais);
        ImageReader reader = null;
        String imageSize = String.format("%1$,d", this.imageBytes.length);
        reader = ImageIO.getImageReaders(imageis).next();
        reader.setInput(imageis);
        String formatName = reader.getFormatName();
        ImageHandler.BasicImageInformation ii = new ImageHandler.BasicImageInformation();
        Platform.runLater(() -> {
            this.xdensity.set(ii.xdensity);
            this.ydensity.set(ii.ydensity);
        });
        if (Precision.equals((float)this.jaiPrefs.getDisplayCompression().get().floatValue(), (float)1.0f, (int)4)) {
            this.bais.reset();
            Platform.runLater(() -> this.statusMessageLabel.setText("Loading image..."));
            fximage = new Image(this.bais);
            if (fximage.isError()) {
                if (!(fximage.getException() instanceof ImageStorageException)) throw new RuntimeException("Unexpected error from JavaFX Image conversion: " + fximage.getException().getLocalizedMessage(), fximage.getException());
                this.bais.reset();
                fximage = SwingFXUtils.toFXImage((BufferedImage)reader.read(0), null);
            }
        } else {
            Platform.runLater(() -> this.statusMessageLabel.setText("Loading image..."));
            IIOImage iioImage = new IIOImage(reader.read(0), null, null);
            imageis.close();
            reader.dispose();
            Platform.runLater(() -> this.statusMessageLabel.setText(String.format("Changing compression to %1$d...", this.jaiPrefs.getDisplayCompression().get())));
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageOutputStream imageos = ImageIO.createImageOutputStream(baos);
            writer.setOutput(imageos);
            JPEGImageWriteParam iqp = new JPEGImageWriteParam(null);
            iqp.setCompressionMode(2);
            iqp.setCompressionType(iqp.getCompressionTypes()[0]);
            iqp.setCompressionQuality(this.jaiPrefs.getDisplayCompression().get().floatValue());
            writer.write(null, iioImage, iqp);
            imageos.close();
            writer.dispose();
            imageis = ImageIO.createImageInputStream(new ByteArrayInputStream(baos.toByteArray()));
            reader = ImageIO.getImageReaders(imageis).next();
            reader.setInput(imageis);
            fximage = SwingFXUtils.toFXImage((BufferedImage)reader.read(0), null);
            imageSize = String.format("%1$,d(compressed jpg %2$,d)", this.imageBytes.length, baos.toByteArray().length);
        }
        imageis.close();
        reader.dispose();
        Platform.runLater(() -> this.statusMessageLabel.setText(this.statusMessageLabel.getText() + "Done"));
        return new ImageInformation(fximage, formatName, imageSize, localMetadata);
    }

    @FXML
    private void saveFired(ActionEvent event) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION, "Not implemented yet", new ButtonType[0]);
        alert.showAndWait();
    }

    @FXML
    private void pasteBase64Fired(ActionEvent event) {
        try {
            this.imageBytes = Base64.getDecoder().decode(Clipboard.getSystemClipboard().getString());
            this.bais = new ByteArrayInputStream(this.imageBytes);
            this.imageName = "*Clipboard*";
            this.setupImageTask();
        }
        catch (RuntimeException e) {
            this.statusMessageLabel.setText(String.format("Error while pasting from clipboard: %1$s", e.getLocalizedMessage()));
        }
    }

    @FXML
    private void copyImageFired(ActionEvent event) {
        if (this.imageView.getImage() != null) {
            ClipboardContent content = new ClipboardContent();
            content.putImage(this.imageView.getImage());
            Clipboard.getSystemClipboard().setContent((Map)content);
            this.statusMessageLabel.setText(String.format("%1$,.0f X %2$,.0f pixels image written to the clipboard.", this.imageView.getImage().getWidth(), this.imageView.getImage().getHeight()));
        }
    }

    @FXML
    private void copyBase64Fired(ActionEvent event) {
        if (this.base64Label.getText() != null && !this.base64Label.getText().isEmpty()) {
            HashMap<DataFormat, String> content = new HashMap<DataFormat, String>();
            content.put(DataFormat.PLAIN_TEXT, this.base64Label.getText());
            Clipboard.getSystemClipboard().setContent(content);
            this.statusMessageLabel.setText(String.format("%1$,d characters written to the clipboard.", this.base64Label.getText().length()));
        }
    }

    @FXML
    private void saveAsFired(ActionEvent event) throws IOException {
        File imageFile = this.configureFileChooser("Save Image As File", this.imageView.getScene().getWindow(), DIALOG_TYPE.saveAs);
        String outFormatName = this.selectedExtensionFilter.getDescription();
        if (imageFile != null) {
            String compressionType = ImageHandler.saveImage(imageFile, outFormatName, this.imageBytes, this.jaiPrefs.getSaveCompression().get().floatValue(), this.jaiPrefs.getDpi().get());
            String imageSize = String.format("%1$,d(%2$,d saved)", this.imageBytes.length, imageFile.length());
            this.statusMessageLabel.setText(String.format("Image %1$s: image size=%2$s, type=%3$s, compression=%4$f, compression type=%5$s", imageFile.getName(), imageSize, outFormatName, this.jaiPrefs.getSaveCompression().get(), compressionType));
        }
    }

    private File configureFileChooser(String title, Window window, DIALOG_TYPE dialogType) throws IOException {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        fileChooser.setInitialDirectory(new File(this.jaiPrefs.getLastDirectory().getString()));
        if (dialogType == DIALOG_TYPE.saveAs) {
            if (this.imageName != null && !this.imageName.isEmpty()) {
                fileChooser.setInitialFileName(this.imageName);
            }
            fileChooser.setSelectedExtensionFilter(this.computeSelectedExtensionFilter(this.imageName));
        }
        fileChooser.getExtensionFilters().addAll((Object[])this.imageIOBasedExtensionFilters);
        File userFile = null;
        try {
            switch (dialogType) {
                case open: {
                    userFile = fileChooser.showOpenDialog(window);
                    break;
                }
                case saveAs: {
                    userFile = fileChooser.showSaveDialog(window);
                }
            }
        }
        catch (IllegalArgumentException e) {
            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
            switch (dialogType) {
                case open: {
                    userFile = fileChooser.showOpenDialog(window);
                    break;
                }
                case saveAs: {
                    userFile = fileChooser.showSaveDialog(window);
                }
            }
        }
        if (userFile != null) {
            String newLastDirectory = userFile.getParentFile().getAbsolutePath();
            if (!fileChooser.getInitialDirectory().getAbsolutePath().equals(newLastDirectory)) {
                this.userPreferences.put(LAST_DIRECTORY_PREF, newLastDirectory);
            }
            if (dialogType == DIALOG_TYPE.saveAs) {
                this.selectedExtensionFilter = fileChooser.getSelectedExtensionFilter();
            }
        }
        return userFile;
    }

    private FileChooser.ExtensionFilter computeSelectedExtensionFilter(String anImageName) {
        for (FileChooser.ExtensionFilter extensionFilter : this.imageIOBasedExtensionFilters) {
            List extensions = extensionFilter.getExtensions();
            for (String extension : extensions) {
                if (!anImageName.endsWith(extension.substring(2))) continue;
                return extensionFilter;
            }
        }
        return null;
    }

    private FileChooser.ExtensionFilter[] createImageIOBasedExtensionFilter() {
        Iterator<ImageReaderSpi> readersSpi;
        LinkedHashSet<FileChooser.ExtensionFilter> filters = new LinkedHashSet<FileChooser.ExtensionFilter>();
        filters.add(new FileChooser.ExtensionFilter("All Images", new String[]{"*.*"}));
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<ImageReaderSpi> iterator = readersSpi = registry.getServiceProviders(ImageReaderSpi.class, false);
        while (iterator.hasNext()) {
            ImageReaderSpi readerSpi = iterator.next();
            LinkedHashSet<String> extensions = new LinkedHashSet<String>();
            for (String suffix : readerSpi.getFileSuffixes()) {
                if (suffix == null || suffix.isEmpty()) {
                    suffix = "*";
                }
                extensions.add("*." + suffix);
            }
            filters.add(new FileChooser.ExtensionFilter(readerSpi.getFormatNames()[0], extensions.toArray(new String[0])));
        }
        return filters.toArray(new FileChooser.ExtensionFilter[0]);
    }

    private /* synthetic */ void lambda$loadBase64Task$6(Task loadBase64Task, ImageInformation ii, WorkerStateEvent event) {
        try {
            String b64 = (String)loadBase64Task.get();
            this.base64Label.setText(b64);
            this.statusMessageLabel.setText(String.format("Image %1$s: image size=%2$s, base64 size=%3$,d, type=%4$s, compression=%5$f", this.imageName, ii.imageSize, ((String)loadBase64Task.get()).length(), ii.formatName, this.jaiPrefs.getDisplayCompression().get()));
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static enum DIALOG_TYPE {
        open,
        saveAs;

    }

    private static class LabelInitializer {
        private LabelInitializer() {
            throw new IllegalAccessError("Do not instantiate, this is a help class");
        }

        public static Label getLabel(String message) {
            Label label = new Label(message);
            label.setWrapText(true);
            return label;
        }
    }

    private static class ImageInformation {
        public Image fximage;
        public String formatName;
        public String imageSize;
        public Metadata metadata;

        public ImageInformation(Image aFxImage, String aFormatName, String anImageSize, Metadata aMetadata) {
            this.fximage = aFxImage;
            this.formatName = aFormatName;
            this.imageSize = anImageSize;
            this.metadata = aMetadata;
        }
    }

    public class ImageReadByChunks
    implements FXUtils.ThrowingFunction<byte[], FXUtils.ProgressResponsiveTask<byte[], IOException>, IOException> {
        private File imageFile;

        public void setImageFile(File anImageFile) {
            this.imageFile = anImageFile;
        }

        public byte[] applyThrows(FXUtils.ProgressResponsiveTask<byte[], IOException> rt) throws IOException {
            int readBytes;
            int length = Integer.MAX_VALUE;
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(this.imageFile));
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            int totalBytes = 0;
            do {
                readBytes = fis.read(buffer, 0, Math.min(buffer.length, length - totalBytes));
                totalBytes += Math.max(readBytes, 0);
                if (readBytes > 0) {
                    baos.write(buffer, 0, readBytes);
                }
                rt.myUpdateProgress(totalBytes);
            } while (totalBytes < length && readBytes > -1);
            fis.close();
            if (length != Integer.MAX_VALUE && totalBytes < length) {
                throw new IOException("unexpected EOF");
            }
            return baos.toByteArray();
        }
    }
}

