/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.jai.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageHandler {
    private static final String JPEG_TREE = "javax_imageio_jpeg_image_1.0";
    public static final int POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
    public static final int NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);
    public static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;

    public static InputStream createIS(byte[] input_image_bytes) {
        return new ByteArrayInputStream(input_image_bytes);
    }

    public static ImageInputStream createImageIS(InputStream is) throws IOException {
        ImageInputStream imageis = null;
        imageis = ImageIO.createImageInputStream(is);
        return imageis;
    }

    public static ImageReader createReader(ImageInputStream imageis) {
        ImageReader reader = null;
        reader = ImageIO.getImageReaders(imageis).next();
        reader.setInput(imageis);
        return reader;
    }

    public static String saveImage(File outputImageFile, String outFormatName, byte[] input_image_bytes, float saveCompression, Integer dpi) throws IOException, FileNotFoundException {
        ImageInputStream imageis = ImageHandler.createImageIS(ImageHandler.createIS(input_image_bytes));
        ImageReader reader = ImageHandler.createReader(imageis);
        ImageWriter writer = ImageHandler.createWriter(outFormatName);
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        String compressionType = ImageHandler.setupSaveImageWriteParam(iwp, saveCompression);
        ImageHandler.writeImageFile(outputImageFile, reader, writer, iwp, dpi, outFormatName);
        imageis.close();
        reader.dispose();
        writer.dispose();
        return compressionType;
    }

    public static ImageWriter createWriter(String outFormatName) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName(outFormatName).next();
        return writer;
    }

    public static String diplayImageMetadata(ImageReader reader, BasicImageInformation ii) throws IOException, TransformerException {
        IIOMetadataNode iionode;
        NodeList apps;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IIOMetadata metadata = reader.getImageMetadata(0);
        Node node = metadata.getAsTree(metadata.getNativeMetadataFormatName());
        if (node instanceof IIOMetadataNode && (apps = (iionode = (IIOMetadataNode)node).getElementsByTagName("app0JFIF")) != null && apps.getLength() > 0) {
            Node app = apps.item(0);
            NamedNodeMap attrs = app.getAttributes();
            Node xdensity = attrs.getNamedItem("Xdensity");
            Node ydensity = attrs.getNamedItem("Ydensity");
            String sxdensity = xdensity.getNodeValue();
            String sydensity = ydensity.getNodeValue();
            try {
                ii.xdensity = Integer.parseInt(sxdensity);
                ii.ydensity = Integer.parseInt(sydensity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return new String(baos.toByteArray());
    }

    public static String setupSaveImageWriteParam(ImageWriteParam iwp, float saveCompression) {
        if (!iwp.canWriteCompressed()) {
            return null;
        }
        iwp.setCompressionMode(2);
        String compressionType = iwp.getCompressionTypes()[0];
        iwp.setCompressionType(compressionType);
        iwp.setCompressionQuality(saveCompression);
        return compressionType;
    }

    public static void writeImageFile(File imageFile, ImageReader reader, ImageWriter writer, ImageWriteParam iwp, Integer dpi, String outFormatName) throws FileNotFoundException, IOException {
        BufferedImage bufferedImage = reader.read(0);
        IIOImage iioImage = new IIOImage(bufferedImage, null, null);
        if ("JPEG".equalsIgnoreCase(outFormatName) && dpi != null) {
            IIOMetadata data = writer.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), iwp);
            Element tree = (Element)data.getAsTree(JPEG_TREE);
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", dpi.toString());
            jfif.setAttribute("Ydensity", dpi.toString());
            jfif.setAttribute("resUnits", "1");
            data.setFromTree(JPEG_TREE, tree);
            iioImage.setMetadata(data);
        }
        FileOutputStream fos = new FileOutputStream(imageFile);
        ImageOutputStream imageos = ImageIO.createImageOutputStream(fos);
        writer.setOutput(imageos);
        writer.write(null, iioImage, iwp);
        imageos.close();
        fos.close();
    }

    public static class BasicImageInformation {
        public int xdensity = -1;
        public int ydensity = -1;
    }
}

